/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.cleanup.CleanupJob;
import org.jabref.logic.formatter.bibtexfields.NormalizeDateFormatter;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Date;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;

public class URLCleanup
implements CleanupJob {
    public static final String URL_REGEX = "(?i)\\b((?:https?://|www\\d{0,3}[.]|[a-z0-9.\\-]+[.][a-z]{2,4}/)(?:[^\\s()<>\\\\]+|\\(([^\\s()<>\\\\]+|(\\([^\\s()<>\\\\]+\\)))*\\))+(?:\\(([^\\s()<>\\\\]+|(\\([^\\s()<>\\\\]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))";
    public static final String DATE_TERMS_REGEX = "accessed on|visited on|retrieved on|viewed on";
    private static final Field NOTE_FIELD = StandardField.NOTE;
    private static final Field URL_FIELD = StandardField.URL;
    private static final Field URLDATE_FIELD = StandardField.URLDATE;
    final Pattern urlPattern = Pattern.compile("(?i)\\b((?:https?://|www\\d{0,3}[.]|[a-z0-9.\\-]+[.][a-z]{2,4}/)(?:[^\\s()<>\\\\]+|\\(([^\\s()<>\\\\]+|(\\([^\\s()<>\\\\]+\\)))*\\))+(?:\\(([^\\s()<>\\\\]+|(\\([^\\s()<>\\\\]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))", 2);
    final Pattern dateTermsPattern = Pattern.compile("accessed on|visited on|retrieved on|viewed on", 2);
    final Pattern datePattern = Pattern.compile(Date.DATE_REGEX, 2);
    private final NormalizeDateFormatter formatter = new NormalizeDateFormatter();

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        String noteFieldValue = entry.getField(NOTE_FIELD).orElse("");
        Matcher urlMatcher = this.urlPattern.matcher(noteFieldValue);
        Matcher dateTermsMatcher = this.dateTermsPattern.matcher(noteFieldValue);
        Matcher dateMatcher = this.datePattern.matcher(noteFieldValue);
        if (urlMatcher.find()) {
            String url = urlMatcher.group();
            String newNoteFieldValue = noteFieldValue.replace(url, "").replaceAll("(, )?\\\\?url\\{\\}(, )?", "");
            if (entry.hasField(URL_FIELD)) {
                String urlFieldValue = entry.getField(URL_FIELD).orElse("");
                if (urlFieldValue.equals(url)) {
                    entry.setField(NOTE_FIELD, newNoteFieldValue).ifPresent(changes::add);
                }
            } else {
                entry.setField(NOTE_FIELD, newNoteFieldValue).ifPresent(changes::add);
                entry.setField(URL_FIELD, url).ifPresent(changes::add);
            }
            if (dateTermsMatcher.find()) {
                String term = dateTermsMatcher.group();
                newNoteFieldValue = newNoteFieldValue.replace(term, "");
                if (dateMatcher.find()) {
                    String date = dateMatcher.group();
                    String formattedDate = this.formatter.format(date);
                    newNoteFieldValue = newNoteFieldValue.replace(date, "").trim().replaceAll("^,|,$", "").trim();
                    if (entry.hasField(URLDATE_FIELD)) {
                        String urlDateFieldValue = entry.getField(URLDATE_FIELD).orElse("");
                        if (urlDateFieldValue.equals(formattedDate)) {
                            entry.setField(NOTE_FIELD, newNoteFieldValue).ifPresent(changes::add);
                        }
                    } else {
                        entry.setField(NOTE_FIELD, newNoteFieldValue).ifPresent(changes::add);
                        entry.setField(URLDATE_FIELD, formattedDate).ifPresent(changes::add);
                    }
                }
            }
        }
        return changes;
    }
}

