/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jabref.logic.exporter.AtomicFileWriter;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.msbib.MSBibDatabase;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jspecify.annotations.NonNull;

class MSBibExporter
extends Exporter {
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public MSBibExporter() {
        super("MSBib", "MS Office 2007", StandardFileType.XML);
    }

    @Override
    public void export(@NonNull BibDatabaseContext databaseContext, @NonNull Path file, @NonNull List<BibEntry> entries) throws SaveException {
        Objects.requireNonNull(databaseContext);
        if (entries.isEmpty()) {
            return;
        }
        MSBibDatabase msBibDatabase = new MSBibDatabase(databaseContext.getDatabase(), entries);
        try (AtomicFileWriter ps = new AtomicFileWriter(file, StandardCharsets.UTF_8);){
            try {
                DOMSource source = new DOMSource(msBibDatabase.getDomForExport());
                StreamResult result = new StreamResult(ps);
                Transformer trans = this.transformerFactory.newTransformer();
                trans.setOutputProperty("indent", "yes");
                trans.transform(source, result);
            }
            catch (IllegalArgumentException | TransformerException | TransformerFactoryConfigurationError e) {
                throw new SaveException(e);
            }
        }
        catch (IOException ex) {
            throw new SaveException(ex);
        }
    }
}

