/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.exporter.AtomicFileWriter;
import org.jabref.logic.exporter.BibDatabaseWriter;
import org.jabref.logic.exporter.BlankLineBehaviour;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.layout.Layout;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.layout.LayoutHelper;
import org.jabref.logic.layout.format.Number;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.metadata.SaveOrder;
import org.jabref.model.metadata.SelfContainedSaveOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateExporter
extends Exporter {
    private static final String BLANK_LINE_PATTERN = "\\r\\n|\\n";
    private static final String LAYOUT_PREFIX = "/resource/layout/";
    private static final String LAYOUT_EXTENSION = ".layout";
    private static final String FORMATTERS_EXTENSION = ".formatters";
    private static final String BEGIN_INFIX = ".begin";
    private static final String END_INFIX = ".end";
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateExporter.class);
    private final String lfFileName;
    private final String directory;
    private final LayoutFormatterPreferences layoutPreferences;
    private final SelfContainedSaveOrder saveOrder;
    private boolean customExport;
    private BlankLineBehaviour blankLineBehaviour;

    public TemplateExporter(String displayName, String consoleName, String lfFileName, String directory, FileType extension) {
        this(displayName, consoleName, lfFileName, directory, extension, null, null, null);
    }

    public TemplateExporter(String name, String lfFileName, String extension, LayoutFormatterPreferences layoutPreferences, SelfContainedSaveOrder saveOrder) {
        this(name, name, lfFileName, null, StandardFileType.fromExtensions(extension), layoutPreferences, saveOrder);
    }

    public TemplateExporter(String displayName, String consoleName, String lfFileName, String directory, FileType extension, LayoutFormatterPreferences layoutPreferences, SelfContainedSaveOrder saveOrder) {
        this(displayName, consoleName, lfFileName, directory, extension, layoutPreferences, saveOrder, null);
    }

    public TemplateExporter(String displayName, String consoleName, String lfFileName, String directory, FileType extension, LayoutFormatterPreferences layoutPreferences, SelfContainedSaveOrder saveOrder, BlankLineBehaviour blankLineBehaviour) {
        super(consoleName, displayName, extension);
        this.lfFileName = Objects.requireNonNull(lfFileName).endsWith(LAYOUT_EXTENSION) ? lfFileName.substring(0, lfFileName.length() - LAYOUT_EXTENSION.length()) : lfFileName;
        this.directory = directory;
        this.layoutPreferences = layoutPreferences;
        this.saveOrder = saveOrder == null ? SaveOrder.getDefaultSaveOrder() : saveOrder;
        this.blankLineBehaviour = blankLineBehaviour;
    }

    public void setCustomExport(boolean custom) {
        this.customExport = custom;
    }

    private Reader getReader(String filename) throws IOException {
        Object dir = this.customExport ? "" : LAYOUT_PREFIX + (String)(this.directory == null ? "" : this.directory + "/");
        String name = (String)dir + filename;
        try {
            URL res = TemplateExporter.class.getResource(name);
            Path reso = res == null ? Path.of(name, new String[0]) : Path.of(res.toURI());
            return Files.newBufferedReader(reso, StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException | URISyntaxException ex) {
            throw new IOException("Cannot find layout file: '" + name + "'.");
        }
    }

    @Override
    public void export(BibDatabaseContext databaseContext, Path file, List<BibEntry> entries) throws Exception {
        this.export(databaseContext, file, entries, Collections.emptyList(), JournalAbbreviationLoader.loadBuiltInRepository());
    }

    @Override
    public void export(BibDatabaseContext databaseContext, Path file, List<BibEntry> entries, List<Path> fileDirForDatabase, JournalAbbreviationRepository abbreviationRepository) throws Exception {
        Objects.requireNonNull(databaseContext);
        Objects.requireNonNull(entries);
        Charset encodingToUse = StandardCharsets.UTF_8;
        if (entries.isEmpty()) {
            return;
        }
        try (AtomicFileWriter ps = new AtomicFileWriter(file, encodingToUse);){
            Layout defLayout;
            LayoutHelper layoutHelper;
            Layout beginLayout = null;
            this.readFormatterFile();
            ArrayList<String> missingFormatters = new ArrayList<String>(1);
            try (Reader reader2 = this.getReader(this.lfFileName + ".begin.layout");){
                LayoutHelper layoutHelper2 = new LayoutHelper(reader2, fileDirForDatabase, this.layoutPreferences, abbreviationRepository);
                beginLayout = layoutHelper2.getLayoutFromText();
            }
            catch (IOException reader2) {
                // empty catch block
            }
            if (beginLayout != null) {
                ps.write(beginLayout.doLayout(databaseContext, encodingToUse));
                missingFormatters.addAll(beginLayout.getMissingFormatters());
            }
            List<BibEntry> sorted = BibDatabaseWriter.getSortedEntries(entries, this.saveOrder);
            try (Reader reader = this.getReader(this.lfFileName + LAYOUT_EXTENSION);){
                layoutHelper = new LayoutHelper(reader, fileDirForDatabase, this.layoutPreferences, abbreviationRepository);
                defLayout = layoutHelper.getLayoutFromText();
            }
            if (defLayout != null) {
                missingFormatters.addAll(defLayout.getMissingFormatters());
                if (!missingFormatters.isEmpty()) {
                    LOGGER.warn("Missing formatters found: {}", missingFormatters);
                }
            }
            HashMap<EntryType, Layout> layouts = new HashMap<EntryType, Layout>();
            Number.serialExportNumber = 0;
            for (BibEntry entry : sorted) {
                Layout layout;
                ++Number.serialExportNumber;
                EntryType type = entry.getType();
                if (layouts.containsKey(type)) {
                    layout = (Layout)layouts.get(type);
                } else {
                    try (Reader reader = this.getReader(this.lfFileName + "." + type.getName() + LAYOUT_EXTENSION);){
                        layoutHelper = new LayoutHelper(reader, fileDirForDatabase, this.layoutPreferences, abbreviationRepository);
                        layout = layoutHelper.getLayoutFromText();
                        layouts.put(type, layout);
                        if (layout != null) {
                            missingFormatters.addAll(layout.getMissingFormatters());
                        }
                    }
                    catch (IOException ex) {
                        layout = defLayout;
                    }
                }
                if (layout == null) continue;
                if (this.blankLineBehaviour == BlankLineBehaviour.DELETE_BLANKS) {
                    String[] lines;
                    for (String line : lines = layout.doLayout(entry, databaseContext.getDatabase()).split(BLANK_LINE_PATTERN)) {
                        if (line.isBlank() || line.isEmpty()) continue;
                        ps.write(line + OS.NEWLINE);
                    }
                    continue;
                }
                ps.write(layout.doLayout(entry, databaseContext.getDatabase()));
            }
            Layout endLayout = null;
            try (Reader reader = this.getReader(this.lfFileName + ".end.layout");){
                layoutHelper = new LayoutHelper(reader, fileDirForDatabase, this.layoutPreferences, abbreviationRepository);
                endLayout = layoutHelper.getLayoutFromText();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (endLayout != null) {
                ps.write(endLayout.doLayout(databaseContext, encodingToUse));
                missingFormatters.addAll(endLayout.getMissingFormatters());
            }
            this.layoutPreferences.clearCustomExportNameFormatters();
            if (!missingFormatters.isEmpty() && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Formatters {} not found", (Object)String.join((CharSequence)", ", missingFormatters));
            }
        }
    }

    private void readFormatterFile() {
        Path formatterFile = Path.of(this.lfFileName + FORMATTERS_EXTENSION, new String[0]);
        if (Files.exists(formatterFile, new LinkOption[0])) {
            try (BufferedReader in = Files.newBufferedReader(formatterFile, StandardCharsets.UTF_8);){
                String[] lines;
                int c;
                StringBuilder sb = new StringBuilder();
                while ((c = ((Reader)in).read()) != -1) {
                    sb.append((char)c);
                }
                for (String line1 : lines = sb.toString().split("\n")) {
                    int index;
                    String line = line1.trim();
                    if (line.isEmpty() || (index = line.indexOf(58)) <= 0 || index + 1 >= line.length()) continue;
                    String formatterName = line.substring(0, index);
                    String contents = line.substring(index + 1);
                    this.layoutPreferences.putCustomExportNameFormatter(formatterName, contents);
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Problem opening formatter file.", (Throwable)ex);
            }
        }
    }

    public String getLayoutFileName() {
        return this.lfFileName;
    }

    public String getLayoutFileNameWithExtension() {
        return this.lfFileName + LAYOUT_EXTENSION;
    }
}

