/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.logic.xmp.XmpUtilWriter;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.InternalField;

public class XmpExporter
extends Exporter {
    public static final String XMP_SPLIT_DIRECTORY_INDICATOR = "split";
    private final XmpPreferences xmpPreferences;

    public XmpExporter(XmpPreferences xmpPreferences) {
        super("xmp", "Plain XMP", StandardFileType.XMP);
        this.xmpPreferences = xmpPreferences;
    }

    @Override
    public void export(BibDatabaseContext databaseContext, Path file, List<BibEntry> entries) throws Exception {
        Objects.requireNonNull(databaseContext);
        Objects.requireNonNull(file);
        Objects.requireNonNull(entries);
        if (entries.isEmpty()) {
            return;
        }
        if (file.getFileName().toString().trim().equals(XMP_SPLIT_DIRECTORY_INDICATOR)) {
            for (BibEntry entry : entries) {
                String suffix = entry.getId() + "_" + entry.getField(InternalField.KEY_FIELD).orElse("null") + ".xmp";
                Path entryFile = file.getParent() == null ? Path.of(suffix, new String[0]) : Path.of(String.valueOf(file.getParent()) + "/" + suffix, new String[0]);
                this.writeBibToXmp(entryFile, Collections.singletonList(entry));
            }
        } else {
            this.writeBibToXmp(file, entries);
        }
    }

    private void writeBibToXmp(Path file, List<BibEntry> entries) throws IOException {
        String xmpContent = new XmpUtilWriter(this.xmpPreferences).generateXmpStringWithoutXmpDeclaration(entries);
        Files.writeString(file, (CharSequence)xmpContent, new OpenOption[0]);
    }
}

