/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.casechanger;

import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.formatter.casechanger.Title;
import org.jabref.logic.formatter.casechanger.Word;
import org.jabref.logic.l10n.Localization;

public class CapitalizeFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("Capitalize", new Object[0]);
    }

    @Override
    public String getKey() {
        return "capitalize";
    }

    @Override
    public String format(String input) {
        Title title = new Title(input);
        title.getWords().stream().forEach(Word::toUpperFirstIgnoreHyphen);
        return title.toString();
    }

    @Override
    public String getDescription() {
        return Localization.lang("Changes The First Letter Of All Words To Capital Case And The Remaining Letters To Lower Case.", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "I have {a} DREAM";
    }
}

