/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.queryparser.flexible.core.QueryNodeParseException;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.standard.parser.StandardSyntaxParser;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.WebFetcher;
import org.jabref.model.entry.BibEntry;

public interface SearchBasedFetcher
extends WebFetcher {
    public List<BibEntry> performSearch(QueryNode var1) throws FetcherException;

    default public List<BibEntry> performSearch(String searchQuery) throws FetcherException {
        QueryNode queryNode;
        if (searchQuery.isBlank()) {
            return Collections.emptyList();
        }
        StandardSyntaxParser parser = new StandardSyntaxParser();
        try {
            queryNode = parser.parse((CharSequence)searchQuery, (CharSequence)"default");
        }
        catch (QueryNodeParseException e) {
            throw new FetcherException("An error occurred when parsing the query");
        }
        return this.performSearch(queryNode);
    }
}

