/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.ParserFetcher;
import org.jabref.logic.importer.SearchBasedFetcher;
import org.jabref.logic.net.ProgressInputStream;
import org.jabref.model.entry.BibEntry;

public interface SearchBasedParserFetcher
extends SearchBasedFetcher,
ParserFetcher {
    @Override
    default public List<BibEntry> performSearch(QueryNode luceneQuery) throws FetcherException {
        URL urlForQuery;
        try {
            urlForQuery = this.getURLForQuery(luceneQuery);
        }
        catch (MalformedURLException | URISyntaxException | FetcherException e) {
            throw new FetcherException("Search URI crafted from complex search query is malformed", e);
        }
        return this.getBibEntries(urlForQuery);
    }

    private List<BibEntry> getBibEntries(URL urlForQuery) throws FetcherException {
        List<BibEntry> list;
        block9: {
            ProgressInputStream stream = this.getUrlDownload(urlForQuery).asInputStream();
            try {
                List<BibEntry> fetchedEntries = this.getParser().parseEntries(stream);
                fetchedEntries.forEach(this::doPostCleanup);
                list = fetchedEntries;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FetcherException("A network error occurred while fetching from " + String.valueOf(urlForQuery), e);
                }
                catch (ParseException e) {
                    throw new FetcherException("An internal parser error occurred while fetching from " + String.valueOf(urlForQuery), e);
                }
            }
            ((InputStream)stream).close();
        }
        return list;
    }

    public Parser getParser();

    public URL getURLForQuery(QueryNode var1) throws URISyntaxException, MalformedURLException, FetcherException;
}

