/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kong.unirest.core.json.JSONArray;
import kong.unirest.core.json.JSONException;
import kong.unirest.core.json.JSONObject;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.jabref.logic.cleanup.FieldFormatterCleanup;
import org.jabref.logic.cleanup.MoveFieldCleanup;
import org.jabref.logic.formatter.bibtexfields.ClearFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeMonthFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeNamesFormatter;
import org.jabref.logic.formatter.bibtexfields.RemoveEnclosingBracesFormatter;
import org.jabref.logic.formatter.bibtexfields.RemoveNewlinesFormatter;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.EntryBasedParserFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdBasedParserFetcher;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ImporterPreferences;
import org.jabref.logic.importer.PagedSearchBasedParserFetcher;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.fetcher.CustomizableKeyFetcher;
import org.jabref.logic.importer.fetcher.transformers.DefaultQueryTransformer;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.net.URLDownload;
import org.jabref.logic.util.BuildInfo;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.paging.Page;
import org.jabref.model.strings.StringUtil;

public class AstrophysicsDataSystem
implements IdBasedParserFetcher,
PagedSearchBasedParserFetcher,
EntryBasedParserFetcher,
CustomizableKeyFetcher {
    private static final String API_SEARCH_URL = "https://api.adsabs.harvard.edu/v1/search/query";
    private static final String API_EXPORT_URL = "https://api.adsabs.harvard.edu/v1/export/bibtexabs";
    private static final String API_KEY = new BuildInfo().astrophysicsDataSystemAPIKey;
    private final ImportFormatPreferences preferences;
    private final ImporterPreferences importerPreferences;

    public AstrophysicsDataSystem(ImportFormatPreferences preferences, ImporterPreferences importerPreferences) {
        this.preferences = Objects.requireNonNull(preferences);
        this.importerPreferences = importerPreferences;
    }

    private static String buildPostData(Collection<String> bibcodes) {
        JSONObject obj = new JSONObject();
        obj.put("bibcode", bibcodes);
        return obj.toString();
    }

    private static URL getURLforExport() throws URISyntaxException, MalformedURLException {
        return new URIBuilder(API_EXPORT_URL).build().toURL();
    }

    @Override
    public String getName() {
        return "SAO/NASA ADS";
    }

    @Override
    public URL getURLForQuery(QueryNode luceneQuery, int pageNumber) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder builder = new URIBuilder(API_SEARCH_URL);
        builder.addParameter("q", new DefaultQueryTransformer().transformLuceneQuery(luceneQuery).orElse(""));
        builder.addParameter("fl", "bibcode");
        builder.addParameter("rows", String.valueOf(this.getPageSize()));
        builder.addParameter("start", String.valueOf(this.getPageSize() * pageNumber));
        return builder.build().toURL();
    }

    @Override
    public URL getURLForEntry(BibEntry entry) throws URISyntaxException, MalformedURLException {
        StringBuilder stringBuilder = new StringBuilder();
        Optional<String> title = entry.getFieldOrAlias(StandardField.TITLE).map(t -> "title:\"" + t + "\"");
        Optional<String> author = entry.getFieldOrAlias(StandardField.AUTHOR).map(a -> "author:\"" + a + "\"");
        if (title.isPresent()) {
            stringBuilder.append(title.get()).append(author.map(s -> " AND " + s).orElse(""));
        } else {
            stringBuilder.append(author.orElse(""));
        }
        String query = stringBuilder.toString().trim();
        URIBuilder builder = new URIBuilder(API_SEARCH_URL);
        builder.addParameter("q", query);
        builder.addParameter("fl", "bibcode");
        builder.addParameter("rows", "20");
        return builder.build().toURL();
    }

    @Override
    public URL getUrlForIdentifier(String identifier) throws FetcherException, URISyntaxException, MalformedURLException {
        String query = "doi:\"" + identifier + "\" OR bibcode:\"" + identifier + "\"";
        URIBuilder builder = new URIBuilder(API_SEARCH_URL);
        builder.addParameter("q", query);
        builder.addParameter("fl", "bibcode");
        return builder.build().toURL();
    }

    @Override
    public Optional<HelpFile> getHelpPage() {
        return Optional.of(HelpFile.FETCHER_ADS);
    }

    @Override
    public Parser getParser() {
        return new BibtexParser(this.preferences);
    }

    @Override
    public void doPostCleanup(BibEntry entry) {
        new FieldFormatterCleanup(StandardField.ABSTRACT, new RemoveEnclosingBracesFormatter()).cleanup(entry);
        new FieldFormatterCleanup(StandardField.ABSTRACT, new RemoveNewlinesFormatter()).cleanup(entry);
        new FieldFormatterCleanup(StandardField.TITLE, new RemoveEnclosingBracesFormatter()).cleanup(entry);
        new FieldFormatterCleanup(StandardField.AUTHOR, new NormalizeNamesFormatter()).cleanup(entry);
        new FieldFormatterCleanup(StandardField.MONTH, new NormalizeMonthFormatter()).cleanup(entry);
        new FieldFormatterCleanup(new UnknownField("adsnote"), new ClearFormatter()).cleanup(entry);
        new MoveFieldCleanup(new UnknownField("adsurl"), StandardField.URL).cleanup(entry);
        entry.getField(StandardField.ABSTRACT).filter("Not Available <P />"::equals).ifPresent(abstractText -> entry.clearField(StandardField.ABSTRACT));
        entry.getField(StandardField.ABSTRACT).map(abstractText -> abstractText.replace("<P />", "")).map(abstractText -> abstractText.replace("\\textbackslash", "")).map(String::trim).ifPresent(abstractText -> entry.setField(StandardField.ABSTRACT, (String)abstractText));
        entry.setCommentsBeforeEntry("");
    }

    @Override
    public List<BibEntry> performSearch(BibEntry entry) throws FetcherException {
        if (entry.getFieldOrAlias(StandardField.TITLE).isEmpty() && entry.getFieldOrAlias(StandardField.AUTHOR).isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<String> bibcodes = this.fetchBibcodes(this.getURLForEntry(entry));
            return this.performSearchByIds(bibcodes);
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (IOException e) {
            throw new FetcherException("A network error occurred", e);
        }
    }

    private List<String> fetchBibcodes(URL url) throws FetcherException {
        try {
            URLDownload download = this.getUrlDownload(url);
            String content = download.asString();
            JSONObject obj = new JSONObject(content);
            JSONArray codes = obj.getJSONObject("response").getJSONArray("docs");
            ArrayList<String> bibcodes = new ArrayList<String>();
            for (int i = 0; i < codes.length(); ++i) {
                bibcodes.add(codes.getJSONObject(i).getString("bibcode"));
            }
            return bibcodes;
        }
        catch (IOException e) {
            throw new FetcherException("A network error occurred", e);
        }
        catch (JSONException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public Optional<BibEntry> performSearchById(String identifier) throws FetcherException {
        if (StringUtil.isBlank(identifier)) {
            return Optional.empty();
        }
        try {
            List<String> bibcodes = this.fetchBibcodes(this.getUrlForIdentifier(identifier));
            List<BibEntry> fetchedEntries = this.performSearchByIds(bibcodes);
            if (fetchedEntries.isEmpty()) {
                return Optional.empty();
            }
            if (fetchedEntries.size() > 1) {
                LOGGER.info("Fetcher " + this.getName() + "found more than one result for identifier " + identifier + ". We will use the first entry.");
            }
            BibEntry entry = fetchedEntries.getFirst();
            return Optional.of(entry);
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (IOException e) {
            throw new FetcherException("A network error occurred", e);
        }
    }

    private List<BibEntry> performSearchByIds(Collection<String> identifiers) throws FetcherException {
        List<String> ids = identifiers.stream().filter(identifier -> !StringUtil.isBlank(identifier)).collect(Collectors.toList());
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            String postData = AstrophysicsDataSystem.buildPostData(ids);
            URLDownload download = new URLDownload(AstrophysicsDataSystem.getURLforExport());
            download.addHeader("Authorization", "Bearer " + this.importerPreferences.getApiKey(this.getName()).orElse(API_KEY));
            download.addHeader("ContentType", "application/json");
            download.setPostData(postData);
            String content = download.asString();
            JSONObject obj = new JSONObject(content);
            try {
                List<BibEntry> fetchedEntries = this.getParser().parseEntries(obj.optString("export"));
                if (fetchedEntries.isEmpty()) {
                    return Collections.emptyList();
                }
                fetchedEntries.forEach(this::doPostCleanup);
                return fetchedEntries;
            }
            catch (JSONException e) {
                return Collections.emptyList();
            }
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (IOException e) {
            throw new FetcherException("A network error occurred", e);
        }
        catch (ParseException e) {
            throw new FetcherException("An internal parser error occurred", e);
        }
    }

    @Override
    public List<BibEntry> performSearch(QueryNode luceneQuery) throws FetcherException {
        URL urlForQuery;
        try {
            urlForQuery = this.getURLForQuery(luceneQuery);
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (IOException e) {
            throw new FetcherException("A network error occurred", e);
        }
        List<String> bibCodes = this.fetchBibcodes(urlForQuery);
        return this.performSearchByIds(bibCodes);
    }

    @Override
    public Page<BibEntry> performSearchPaged(QueryNode luceneQuery, int pageNumber) throws FetcherException {
        URL urlForQuery;
        try {
            urlForQuery = this.getURLForQuery(luceneQuery, pageNumber);
        }
        catch (URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (IOException e) {
            throw new FetcherException("A network error occurred", e);
        }
        List<String> bibCodes = this.fetchBibcodes(urlForQuery);
        List<BibEntry> results = this.performSearchByIds(bibCodes);
        return new Page<BibEntry>(luceneQuery.toString(), pageNumber, results);
    }

    @Override
    public URLDownload getUrlDownload(URL url) {
        URLDownload urlDownload = new URLDownload(url);
        urlDownload.addHeader("Authorization", "Bearer " + this.importerPreferences.getApiKey(this.getName()).orElse(API_KEY));
        return urlDownload;
    }
}

