/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import org.apache.hc.core5.net.URIBuilder;
import org.jabref.logic.importer.EntryBasedFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.MrDLibImporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.net.URLDownload;
import org.jabref.logic.util.Version;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.MrDlibPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrDLibFetcher
implements EntryBasedFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MrDLibFetcher.class);
    private static final String NAME = "MDL_FETCHER";
    private static final String MDL_JABREF_PARTNER_ID = "1";
    private static final String MDL_URL = "api.mr-dlib.org";
    private static final String DEFAULT_MRDLIB_ERROR_MESSAGE = Localization.lang("Error while fetching recommendations from Mr.DLib.", new Object[0]);
    private final String LANGUAGE;
    private final Version VERSION;
    private String heading;
    private String description;
    private String recommendationSetId;
    private final MrDlibPreferences preferences;

    public MrDLibFetcher(String language, Version version, MrDlibPreferences preferences) {
        this.LANGUAGE = language;
        this.VERSION = version;
        this.preferences = preferences;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<BibEntry> performSearch(BibEntry entry) throws FetcherException {
        Optional<String> title = entry.getFieldLatexFree(StandardField.TITLE);
        if (title.isPresent()) {
            ParserResult parserResult;
            String response = this.makeServerRequest(title.get());
            MrDLibImporter importer = new MrDLibImporter();
            try {
                if (importer.isRecognizedFormat(response)) {
                    parserResult = importer.importDatabase(response);
                    this.heading = importer.getRecommendationsHeading();
                    this.description = importer.getRecommendationsDescription();
                    this.recommendationSetId = importer.getRecommendationSetId();
                } else {
                    this.description = DEFAULT_MRDLIB_ERROR_MESSAGE;
                    BibDatabase errorBibDataBase = new BibDatabase();
                    parserResult = new ParserResult(errorBibDataBase);
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new FetcherException("JSON Parser IOException.");
            }
            return parserResult.getDatabase().getEntries();
        }
        return new ArrayList<BibEntry>(0);
    }

    public String getHeading() {
        return this.heading;
    }

    public String getDescription() {
        return this.description;
    }

    private String makeServerRequest(String queryByTitle) throws FetcherException {
        try {
            URLDownload urlDownload = new URLDownload(this.constructQuery(queryByTitle));
            String response = urlDownload.asString();
            response = response.replace("&gt;", ">");
            response = response.replace("&lt;", "<");
            return response;
        }
        catch (IOException e) {
            throw new FetcherException("Problem downloading", e);
        }
    }

    private String constructQuery(String queryWithTitle) {
        queryWithTitle = queryWithTitle.replace("/", " ");
        URIBuilder builder = new URIBuilder();
        builder.setScheme("http");
        builder.setHost(MDL_URL);
        builder.setPath("/v2/documents/" + queryWithTitle + "/related_documents");
        builder.addParameter("partner_id", MDL_JABREF_PARTNER_ID);
        builder.addParameter("app_id", "jabref_desktop");
        builder.addParameter("app_version", this.VERSION.getFullVersion());
        if (this.preferences.shouldSendLanguage()) {
            builder.addParameter("app_lang", this.LANGUAGE);
        }
        if (this.preferences.shouldSendOs()) {
            builder.addParameter("os", System.getProperty("os.name"));
        }
        if (this.preferences.shouldSendTimezone()) {
            builder.addParameter("timezone", Calendar.getInstance().getTimeZone().getID());
        }
        try {
            URI uri = builder.build();
            LOGGER.trace("Request: " + uri.toString());
            return uri.toString();
        }
        catch (URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }
}

