/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.StandardEntryType;

public class CoinsParser
implements Parser {
    private final Pattern DOI = Pattern.compile("%3Fdoi%3D([^&]+)");
    private final Pattern TITLE = Pattern.compile("&amp;rft.atitle=([^&]+)");
    private final Pattern JOURNAL = Pattern.compile("&amp;rft.jtitle=([^&]+)");
    private final Pattern YEAR = Pattern.compile("&amp;rft.date=([^&]+)");
    private final Pattern VOLUME = Pattern.compile("&amp;rft.volume=([^&]+)");
    private final Pattern PAGES = Pattern.compile("&amp;rft.pages=([^&]+)");
    private final Pattern ISSUE = Pattern.compile("&amp;rft.issue=([^&]+)");
    private final Pattern TYPE = Pattern.compile("&amp;rft.genre=([^&]+)");
    private final Pattern AUTHOR = Pattern.compile("&amp;rft.au=([^&]+)");

    @Override
    public List<BibEntry> parseEntries(InputStream inputStream) throws ParseException {
        String data = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining(OS.NEWLINE));
        BibEntry entry = new BibEntry();
        this.appendData(data, entry, this.DOI, StandardField.DOI);
        this.appendData(data, entry, this.TITLE, StandardField.TITLE);
        this.appendData(data, entry, this.JOURNAL, StandardField.JOURNALTITLE);
        this.appendData(data, entry, this.YEAR, StandardField.YEAR);
        this.appendData(data, entry, this.VOLUME, StandardField.VOLUME);
        this.appendData(data, entry, this.PAGES, StandardField.PAGES);
        this.appendData(data, entry, this.ISSUE, StandardField.ISSUE);
        Matcher matcherType = this.TYPE.matcher(data);
        if (matcherType.find()) {
            switch (matcherType.group(1)) {
                case "article": {
                    entry.setType(StandardEntryType.Article);
                    break;
                }
                default: {
                    entry.setType(StandardEntryType.Misc);
                }
            }
        }
        ArrayList<String> authors = new ArrayList<String>();
        Matcher matcherAuthors = this.AUTHOR.matcher(data);
        while (matcherAuthors.find()) {
            String author = matcherAuthors.group(1);
            authors.add(author);
        }
        entry.setField(StandardField.AUTHOR, String.join((CharSequence)" and ", authors));
        return Collections.singletonList(entry);
    }

    private void appendData(String data, BibEntry entry, Pattern pattern, Field field) {
        Matcher matcher = pattern.matcher(data);
        if (matcher.find()) {
            entry.setField(field, matcher.group(1));
        }
    }
}

