/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.StandardEntryType;

public class MedlinePlainImporter
extends Importer {
    private static final Pattern PMID_PATTERN = Pattern.compile("PMID.*-.*");
    private static final Pattern PMC_PATTERN = Pattern.compile("PMC.*-.*");
    private static final Pattern PMCR_PATTERN = Pattern.compile("PMCR.*-.*");
    private static final Pattern CREATE_DATE_PATTERN = Pattern.compile("\\d{4}/[0123]?\\d/\\s?[012]\\d:[0-5]\\d");
    private static final Pattern COMPLETE_DATE_PATTERN = Pattern.compile("\\d{8}");
    private final ImportFormatPreferences importFormatPreferences;

    public MedlinePlainImporter(ImportFormatPreferences importFormatPreferences) {
        this.importFormatPreferences = importFormatPreferences;
    }

    @Override
    public String getName() {
        return "Medline/PubMed Plain";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.MEDLINE_PLAIN;
    }

    @Override
    public String getDescription() {
        return "Importer for the MedlinePlain format.";
    }

    @Override
    public String getId() {
        return "medlineplain";
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader reader) throws IOException {
        String str;
        while ((str = reader.readLine()) != null) {
            if (!PMID_PATTERN.matcher(str).find() && !PMC_PATTERN.matcher(str).find() && !PMCR_PATTERN.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        String[] entries;
        ArrayList<BibEntry> bibitems = new ArrayList<BibEntry>();
        String linesAsString = reader.lines().reduce((line, nextline) -> line + "\n" + nextline).orElse("");
        for (String entry1 : entries = linesAsString.replace("\u2013", "-").replace("\u2014", "--").replace("\u2015", "--").split("\\n\\n")) {
            if (entry1.trim().isEmpty() || !entry1.contains("-")) continue;
            EntryType type = BibEntry.DEFAULT_TYPE;
            StringBuilder author = new StringBuilder();
            StringBuilder editor = new StringBuilder();
            StringBuilder comment = new StringBuilder();
            HashMap<Field, String> fieldConversionMap = new HashMap<Field, String>();
            String[] lines = entry1.split("\n");
            block29: for (int j = 0; j < lines.length; ++j) {
                StringBuilder current = new StringBuilder(lines[j]);
                boolean done = false;
                while (!done && j < lines.length - 1) {
                    if (lines[j + 1].length() <= 4) {
                        ++j;
                        continue;
                    }
                    if (lines[j + 1].charAt(4) != '-') {
                        if (!current.isEmpty() && !Character.isWhitespace(current.charAt(current.length() - 1))) {
                            current.append(' ');
                        }
                        current.append(lines[j + 1].trim());
                        ++j;
                        continue;
                    }
                    done = true;
                }
                String entry = current.toString();
                if (!this.checkLineValidity(entry)) continue;
                String label = entry.substring(0, entry.indexOf(45)).trim();
                String value = entry.substring(entry.indexOf(45) + 1).trim();
                if ("PT".equals(label)) {
                    type = this.addSourceType(value, type);
                }
                this.addDates(fieldConversionMap, label, value);
                this.addAbstract(fieldConversionMap, label, value);
                this.addTitles(fieldConversionMap, label, value, type);
                this.addIDs(fieldConversionMap, label, value);
                this.addStandardNumber(fieldConversionMap, label, value);
                if ("FAU".equals(label)) {
                    if (author.isEmpty()) {
                        author = new StringBuilder(value);
                    } else {
                        author.append(" and ").append(value);
                    }
                } else if ("FED".equals(label)) {
                    if (editor.isEmpty()) {
                        editor = new StringBuilder(value);
                    } else {
                        editor.append(" and ").append(value);
                    }
                }
                HashMap<String, Field> hashMap = new HashMap<String, Field>();
                hashMap.put("PG", StandardField.PAGES);
                hashMap.put("PL", StandardField.ADDRESS);
                hashMap.put("PHST", new UnknownField("history"));
                hashMap.put("PST", new UnknownField("publication-status"));
                hashMap.put("VI", StandardField.VOLUME);
                hashMap.put("LA", StandardField.LANGUAGE);
                hashMap.put("PUBM", new UnknownField("model"));
                hashMap.put("RN", new UnknownField("registry-number"));
                hashMap.put("NM", new UnknownField("substance-name"));
                hashMap.put("OCI", new UnknownField("copyright-owner"));
                hashMap.put("CN", new UnknownField("corporate"));
                hashMap.put("IP", StandardField.ISSUE);
                hashMap.put("EN", StandardField.EDITION);
                hashMap.put("GS", new UnknownField("gene-symbol"));
                hashMap.put("GN", StandardField.NOTE);
                hashMap.put("GR", new UnknownField("grantno"));
                hashMap.put("SO", new UnknownField("source"));
                hashMap.put("NR", new UnknownField("number-of-references"));
                hashMap.put("SFM", new UnknownField("space-flight-mission"));
                hashMap.put("STAT", new UnknownField("status"));
                hashMap.put("SB", new UnknownField("subset"));
                hashMap.put("OTO", new UnknownField("termowner"));
                hashMap.put("OWN", StandardField.OWNER);
                for (Map.Entry mapEntry : hashMap.entrySet()) {
                    String medlineKey = (String)mapEntry.getKey();
                    Field bibtexKey = (Field)mapEntry.getValue();
                    if (!medlineKey.equals(label)) continue;
                    fieldConversionMap.put(bibtexKey, value);
                }
                switch (label) {
                    case "IRAD": 
                    case "IR": 
                    case "FIR": {
                        fieldConversionMap.merge(new UnknownField("investigator"), value, (a, b) -> a + ", " + b);
                        continue block29;
                    }
                    case "MH": 
                    case "OT": {
                        if (!fieldConversionMap.containsKey(StandardField.KEYWORDS)) {
                            fieldConversionMap.put(StandardField.KEYWORDS, value);
                            continue block29;
                        }
                        fieldConversionMap.compute(StandardField.KEYWORDS, (k, kw) -> kw + this.importFormatPreferences.bibEntryPreferences().getKeywordSeparator() + " " + value);
                        continue block29;
                    }
                    case "CON": 
                    case "CIN": 
                    case "EIN": 
                    case "EFR": 
                    case "CRI": 
                    case "CRF": 
                    case "PRIN": 
                    case "PROF": 
                    case "RPI": 
                    case "RPF": 
                    case "RIN": 
                    case "ROF": 
                    case "UIN": 
                    case "UOF": 
                    case "SPIN": 
                    case "ORI": {
                        if (!comment.isEmpty()) {
                            comment.append("\n");
                        }
                        comment.append(value);
                    }
                }
            }
            this.fixAuthors(fieldConversionMap, author.toString(), StandardField.AUTHOR);
            this.fixAuthors(fieldConversionMap, editor.toString(), StandardField.EDITOR);
            if (!comment.isEmpty()) {
                fieldConversionMap.put(StandardField.COMMENT, comment.toString());
            }
            BibEntry b2 = new BibEntry(type);
            b2.setField(fieldConversionMap);
            bibitems.add(b2);
        }
        return new ParserResult(bibitems);
    }

    private boolean checkLineValidity(String line) {
        return line.length() >= 5 && line.charAt(4) == '-';
    }

    private EntryType addSourceType(String value, EntryType type) {
        String val;
        return switch (val = value.toLowerCase(Locale.ENGLISH)) {
            case "book" -> StandardEntryType.Book;
            case "journal article", "classical article", "corrected and republished article", "historical article", "introductory journal article", "newspaper article" -> StandardEntryType.Article;
            case "clinical conference", "consensus development conference", "consensus development conference, nih" -> StandardEntryType.Conference;
            case "technical report" -> StandardEntryType.TechReport;
            case "editorial" -> StandardEntryType.InProceedings;
            case "overall" -> StandardEntryType.Proceedings;
            default -> type;
        };
    }

    private void addStandardNumber(Map<Field, String> hm, String lab, String value) {
        if ("IS".equals(lab)) {
            Field key = StandardField.ISSN;
            if (value.indexOf(40) > 0) {
                int keyStart = value.indexOf(40);
                int keyEnd = value.indexOf(41);
                key = new UnknownField(value.substring(keyStart + 1, keyEnd) + "-" + String.valueOf(key));
                String numberValue = value.substring(0, keyStart - 1);
                hm.put(key, numberValue);
            } else {
                hm.put(key, value);
            }
        } else if ("ISBN".equals(lab)) {
            hm.put(StandardField.ISBN, value);
        }
    }

    private void fixAuthors(Map<Field, String> hm, String author, Field field) {
        if (!author.isEmpty()) {
            String fixedAuthor = AuthorList.fixAuthorLastNameFirst(author);
            hm.put(field, fixedAuthor);
        }
    }

    private void addIDs(Map<Field, String> hm, String lab, String value) {
        if ("AID".equals(lab)) {
            Field key = new UnknownField("article-id");
            String idValue = value;
            if (value.startsWith("doi:")) {
                idValue = idValue.replaceAll("(?i)doi:", "").trim();
                key = StandardField.DOI;
            } else if (value.indexOf(91) > 0) {
                int startOfIdentifier = value.indexOf(91);
                int endOfIdentifier = value.indexOf(93);
                key = new UnknownField("article-" + value.substring(startOfIdentifier + 1, endOfIdentifier));
                idValue = value.substring(0, startOfIdentifier - 1);
            }
            hm.put(key, idValue);
        } else if ("LID".equals(lab)) {
            hm.put(new UnknownField("location-id"), value);
        } else if ("MID".equals(lab)) {
            hm.put(new UnknownField("manuscript-id"), value);
        } else if ("JID".equals(lab)) {
            hm.put(new UnknownField("nlm-unique-id"), value);
        } else if ("OID".equals(lab)) {
            hm.put(new UnknownField("other-id"), value);
        } else if ("SI".equals(lab)) {
            hm.put(new UnknownField("second-id"), value);
        }
    }

    private void addTitles(Map<Field, String> hm, String lab, String val, EntryType type) {
        if ("TI".equals(lab)) {
            String oldVal = hm.get(StandardField.TITLE);
            if (oldVal == null) {
                hm.put(StandardField.TITLE, val);
            } else if (oldVal.endsWith(":") || oldVal.endsWith(".") || oldVal.endsWith("?")) {
                hm.put(StandardField.TITLE, oldVal + " " + val);
            } else {
                hm.put(StandardField.TITLE, oldVal + ": " + val);
            }
        } else if ("BTI".equals(lab) || "CTI".equals(lab)) {
            hm.put(StandardField.BOOKTITLE, val);
        } else if ("JT".equals(lab)) {
            if (type.equals(StandardEntryType.InProceedings)) {
                hm.put(StandardField.BOOKTITLE, val);
            } else {
                hm.put(StandardField.JOURNAL, val);
            }
        } else if ("CTI".equals(lab)) {
            hm.put(new UnknownField("collection-title"), val);
        } else if ("TA".equals(lab)) {
            hm.put(new UnknownField("title-abbreviation"), val);
        } else if ("TT".equals(lab)) {
            hm.put(new UnknownField("transliterated-title"), val);
        } else if ("VTI".equals(lab)) {
            hm.put(new UnknownField("volume-title"), val);
        }
    }

    private void addAbstract(Map<Field, String> hm, String lab, String value) {
        if ("AB".equals(lab)) {
            String abstractValue;
            if (value.contains("Copyright")) {
                int copyrightIndex = value.lastIndexOf("Copyright");
                String copyrightInfo = value.substring(copyrightIndex).replace("Copyright ", "");
                hm.put(new UnknownField("copyright"), copyrightInfo);
                abstractValue = value.substring(0, copyrightIndex).trim();
            } else {
                abstractValue = value;
            }
            hm.merge(StandardField.ABSTRACT, abstractValue, (a, b) -> a + "\n" + b);
        } else if ("OAB".equals(lab) || "OABL".equals(lab)) {
            hm.put(new UnknownField("other-abstract"), value);
        }
    }

    private void addDates(Map<Field, String> hm, String lab, String val) {
        if ("CRDT".equals(lab) && this.isCreateDateFormat(val)) {
            hm.put(new UnknownField("create-date"), val);
        } else if ("DEP".equals(lab) && this.isDateFormat(val)) {
            hm.put(new UnknownField("electronic-publication"), val);
        } else if ("DA".equals(lab) && this.isDateFormat(val)) {
            hm.put(new UnknownField("date-created"), val);
        } else if ("DCOM".equals(lab) && this.isDateFormat(val)) {
            hm.put(new UnknownField("completed"), val);
        } else if ("LR".equals(lab) && this.isDateFormat(val)) {
            hm.put(new UnknownField("revised"), val);
        } else if ("DP".equals(lab)) {
            String[] parts = val.split(" ");
            hm.put(StandardField.YEAR, parts[0]);
            if (parts.length > 1 && !parts[1].isEmpty()) {
                hm.put(StandardField.MONTH, parts[1]);
            }
        } else if ("EDAT".equals(lab) && this.isCreateDateFormat(val)) {
            hm.put(new UnknownField("publication"), val);
        } else if ("MHDA".equals(lab) && this.isCreateDateFormat(val)) {
            hm.put(new UnknownField("mesh-date"), val);
        }
    }

    private boolean isCreateDateFormat(String value) {
        return CREATE_DATE_PATTERN.matcher(value).matches();
    }

    private boolean isDateFormat(String value) {
        return COMPLETE_DATE_PATTERN.matcher(value).matches();
    }
}

