/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.xmp.EncryptedPdfsNotSupportedException;
import org.jabref.logic.xmp.XmpUtilReader;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.strings.StringUtil;

public class PdfContentImporter
extends Importer {
    private static final Pattern YEAR_EXTRACT_PATTERN = Pattern.compile("\\d{4}");
    private String[] lines;
    private int lineIndex;
    private String curString;
    private String year;

    private String removeNonLettersAtEnd(String input) {
        String result = input.trim();
        if (result.isEmpty()) {
            return result;
        }
        char lastC = result.charAt(result.length() - 1);
        while (!Character.isLetter(lastC) && lastC != ')' && !(result = result.substring(0, result.length() - 1)).isEmpty()) {
            lastC = result.charAt(result.length() - 1);
        }
        return result;
    }

    private String streamlineNames(String names) {
        String res;
        if (names.contains(",")) {
            String[] splitNames = names.split(",");
            res = "";
            boolean isFirst = true;
            for (String splitName : splitNames) {
                String curName = this.removeNonLettersAtEnd(splitName);
                if (curName.indexOf("and") == 0) {
                    curName = curName.substring(3).trim();
                } else {
                    int posAnd = curName.indexOf(" and ");
                    if (posAnd >= 0) {
                        String nameBefore = curName.substring(0, posAnd);
                        res = res.concat(" and ").concat(this.removeNonLettersAtEnd(nameBefore));
                        curName = curName.substring(posAnd + 5);
                    }
                }
                if (curName.isEmpty()) continue;
                if ("et al.".equalsIgnoreCase(curName)) {
                    curName = "others";
                }
                if (isFirst) {
                    isFirst = false;
                } else {
                    res = res.concat(" and ");
                }
                res = res.concat(curName);
            }
        } else {
            String[] splitNames = names.split(" ");
            if (splitNames.length == 0) {
                return "";
            }
            boolean workedOnFirstOrMiddle = false;
            boolean isFirst = true;
            int i = 0;
            res = "";
            do {
                if (workedOnFirstOrMiddle) {
                    if (splitNames[i].contains(".")) {
                        res = res.concat(splitNames[i]).concat(" ");
                        continue;
                    }
                    res = res.concat(this.removeNonLettersAtEnd(splitNames[i]));
                    if (!splitNames[i].isEmpty() && Character.isLowerCase(splitNames[i].charAt(0))) {
                        res = res.concat(" ");
                        continue;
                    }
                    workedOnFirstOrMiddle = false;
                    continue;
                }
                if ("and".equalsIgnoreCase(splitNames[i])) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    res = res.concat(" and ");
                }
                if ("et".equalsIgnoreCase(splitNames[i]) && splitNames.length > i + 1 && "al.".equalsIgnoreCase(splitNames[i + 1])) {
                    res = res.concat("others");
                    break;
                }
                res = res.concat(splitNames[i]).concat(" ");
                workedOnFirstOrMiddle = true;
            } while (++i < splitNames.length);
        }
        return res;
    }

    private String streamlineTitle(String title) {
        return this.removeNonLettersAtEnd(title);
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader input) throws IOException {
        return input.readLine().startsWith("%PDF");
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        Objects.requireNonNull(reader);
        throw new UnsupportedOperationException("PdfContentImporter does not support importDatabase(BufferedReader reader).Instead use importDatabase(Path filePath, Charset defaultEncoding).");
    }

    @Override
    public ParserResult importDatabase(Path filePath) {
        ArrayList<BibEntry> result = new ArrayList<BibEntry>(1);
        try (PDDocument document = new XmpUtilReader().loadWithAutomaticDecryption(filePath);){
            String firstPageContents = this.getFirstPageContents(document);
            Optional<BibEntry> entry2 = this.getEntryFromPDFContent(firstPageContents, OS.NEWLINE);
            entry2.ifPresent(result::add);
        }
        catch (EncryptedPdfsNotSupportedException e) {
            return ParserResult.fromErrorMessage(Localization.lang("Decryption not supported.", new Object[0]));
        }
        catch (IOException exception) {
            return ParserResult.fromError(exception);
        }
        result.forEach(entry -> entry.addFile(new LinkedFile("", filePath.toAbsolutePath(), "PDF")));
        return new ParserResult(result);
    }

    Optional<BibEntry> getEntryFromPDFContent(String firstpageContents, String lineSeparator) {
        String lower;
        String firstpageContentsUnifiedLineBreaks = StringUtil.unifyLineBreaks(firstpageContents, lineSeparator);
        this.lines = firstpageContentsUnifiedLineBreaks.split(lineSeparator);
        this.lineIndex = 0;
        this.proceedToNextNonEmptyLine();
        if (this.lineIndex >= this.lines.length) {
            return Optional.empty();
        }
        this.curString = this.lines[this.lineIndex];
        ++this.lineIndex;
        String editor = null;
        String abstractT = null;
        String keywords = null;
        String conference = null;
        String DOI2 = null;
        String series = null;
        String volume = null;
        String number = null;
        String pages = null;
        String publisher = null;
        StandardEntryType type = StandardEntryType.InProceedings;
        if (this.curString.length() > 4) {
            this.extractYear();
            if (this.curString.contains("Conference")) {
                this.fillCurStringWithNonEmptyLines();
                conference = this.curString;
                this.curString = "";
            } else {
                lower = this.curString.toLowerCase(Locale.ROOT);
                if (lower.contains("copyright")) {
                    this.fillCurStringWithNonEmptyLines();
                    publisher = this.curString;
                    this.curString = "";
                }
            }
        }
        this.fillCurStringWithNonEmptyLines();
        String title = this.streamlineTitle(this.curString);
        this.curString = "";
        String author = null;
        while (this.lineIndex < this.lines.length && !"".equals(this.lines[this.lineIndex])) {
            this.curString = this.streamlineNames(this.lines[this.lineIndex]);
            if (author == null) {
                author = this.curString;
            } else if (!"".equals(this.curString)) {
                author = author.concat(" and ").concat(this.curString);
            }
            ++this.lineIndex;
        }
        this.curString = "";
        ++this.lineIndex;
        while (this.lineIndex < this.lines.length) {
            this.curString = this.lines[this.lineIndex];
            if (this.curString.length() >= "Abstract".length() && "Abstract".equalsIgnoreCase(this.curString.substring(0, "Abstract".length()))) {
                this.curString = this.curString.length() == "Abstract".length() ? "" : this.curString.substring("Abstract".length() + 1).trim().concat(System.lineSeparator());
                ++this.lineIndex;
                while (this.lineIndex < this.lines.length && !"".equals(this.lines[this.lineIndex])) {
                    this.curString = this.curString.concat(this.lines[this.lineIndex]).concat(System.lineSeparator());
                    ++this.lineIndex;
                }
                abstractT = this.curString.trim();
                ++this.lineIndex;
                continue;
            }
            if (this.curString.length() >= "Keywords".length() && "Keywords".equalsIgnoreCase(this.curString.substring(0, "Keywords".length()))) {
                this.curString = this.curString.length() == "Keywords".length() ? "" : this.curString.substring("Keywords".length() + 1).trim();
                ++this.lineIndex;
                this.fillCurStringWithNonEmptyLines();
                keywords = this.removeNonLettersAtEnd(this.curString);
                continue;
            }
            lower = this.curString.toLowerCase(Locale.ROOT);
            int pos = lower.indexOf("technical");
            if (pos >= 0) {
                type = StandardEntryType.TechReport;
                pos = this.curString.trim().lastIndexOf(32);
                if (pos >= 0) {
                    number = this.curString.substring(pos + 1);
                }
            }
            ++this.lineIndex;
            this.proceedToNextNonEmptyLine();
        }
        this.lineIndex = this.lines.length - 1;
        while (this.lineIndex >= 0) {
            this.readLastBlock();
            this.extractYear();
            int pos = this.curString.indexOf("(Eds.)");
            if (pos >= 0 && publisher == null) {
                publisher = "Springer";
                editor = this.streamlineNames(this.curString.substring(0, pos - 1));
                int edslength = "(Eds.)".length();
                int posWithEditor = pos + edslength + 2;
                this.curString = posWithEditor > this.curString.length() ? this.curString.substring(posWithEditor - 2) : this.curString.substring(posWithEditor);
                String[] springerSplit = this.curString.split(", ");
                if (springerSplit.length < 4) continue;
                conference = springerSplit[0];
                String seriesData = springerSplit[1];
                int lastSpace = seriesData.lastIndexOf(32);
                series = seriesData.substring(0, lastSpace);
                volume = seriesData.substring(lastSpace + 1);
                pages = springerSplit[2].substring(4);
                if (springerSplit[3].length() < 4) continue;
                this.year = springerSplit[3].substring(0, 4);
                continue;
            }
            if (DOI2 == null) {
                pos = this.curString.indexOf("DOI");
                if (pos < 0) {
                    pos = this.curString.indexOf(StandardField.DOI.getName());
                }
                if (pos >= 0 && this.curString.length() > (pos += 3)) {
                    int nextSpace;
                    char delimiter = this.curString.charAt(pos);
                    if (delimiter == ':' || delimiter == ' ') {
                        ++pos;
                    }
                    DOI2 = (nextSpace = this.curString.indexOf(32, pos)) > 0 ? this.curString.substring(pos, nextSpace) : this.curString.substring(pos);
                }
            }
            if (publisher != null || !this.curString.contains("IEEE")) continue;
            publisher = "IEEE";
            if (conference != null || (pos = this.curString.indexOf(36)) <= 0) continue;
            pos -= 2;
            while (pos >= 0 && this.curString.charAt(pos) != ' ') {
                --pos;
            }
            if (pos <= 0) continue;
            conference = this.curString.substring(0, pos);
        }
        BibEntry entry = new BibEntry();
        entry.setType(type);
        if (author != null) {
            entry.setField(StandardField.AUTHOR, author);
        }
        if (editor != null) {
            entry.setField(StandardField.EDITOR, editor);
        }
        if (abstractT != null) {
            entry.setField(StandardField.ABSTRACT, abstractT);
        }
        if (!Strings.isNullOrEmpty(keywords)) {
            entry.setField(StandardField.KEYWORDS, keywords);
        }
        if (title != null) {
            entry.setField(StandardField.TITLE, title);
        }
        if (conference != null) {
            entry.setField(StandardField.BOOKTITLE, conference);
        }
        if (DOI2 != null) {
            entry.setField(StandardField.DOI, DOI2);
        }
        if (series != null) {
            entry.setField(StandardField.SERIES, series);
        }
        if (volume != null) {
            entry.setField(StandardField.VOLUME, volume);
        }
        if (number != null) {
            entry.setField(StandardField.NUMBER, number);
        }
        if (pages != null) {
            entry.setField(StandardField.PAGES, pages);
        }
        if (this.year != null) {
            entry.setField(StandardField.YEAR, this.year);
        }
        if (publisher != null) {
            entry.setField(StandardField.PUBLISHER, publisher);
        }
        return Optional.of(entry);
    }

    private String getFirstPageContents(PDDocument document) throws IOException {
        PDFTextStripper stripper = new PDFTextStripper();
        stripper.setStartPage(1);
        stripper.setEndPage(1);
        stripper.setSortByPosition(true);
        stripper.setParagraphEnd(System.lineSeparator());
        StringWriter writer = new StringWriter();
        stripper.writeText(document, (Writer)writer);
        return writer.toString();
    }

    private void extractYear() {
        if (this.year != null) {
            return;
        }
        Matcher m = YEAR_EXTRACT_PATTERN.matcher(this.curString);
        if (m.find()) {
            this.year = this.curString.substring(m.start(), m.end());
        }
    }

    private void proceedToNextNonEmptyLine() {
        while (this.lineIndex < this.lines.length && this.lines[this.lineIndex].trim().isEmpty()) {
            ++this.lineIndex;
        }
    }

    private void fillCurStringWithNonEmptyLines() {
        this.curString = this.curString.trim();
        while (this.lineIndex < this.lines.length && !"".equals(this.lines[this.lineIndex])) {
            String curLine = this.lines[this.lineIndex].trim();
            if (!curLine.isEmpty()) {
                if (!this.curString.isEmpty()) {
                    this.curString = this.curString.concat(" ");
                }
                this.curString = this.curString.concat(this.lines[this.lineIndex]);
            }
            ++this.lineIndex;
        }
        this.proceedToNextNonEmptyLine();
    }

    private void readLastBlock() {
        while (this.lineIndex >= 0 && this.lines[this.lineIndex].trim().isEmpty()) {
            --this.lineIndex;
        }
        int end = this.lineIndex;
        while (this.lineIndex >= 0 && !"".equals(this.lines[this.lineIndex])) {
            --this.lineIndex;
        }
        this.curString = "";
        for (int j = this.lineIndex + 1; j <= end; ++j) {
            this.curString = this.curString.concat(this.lines[j].trim());
            if (j == end) continue;
            this.curString = this.curString.concat(" ");
        }
    }

    @Override
    public String getName() {
        return "PDFcontent";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.PDF;
    }

    @Override
    public String getDescription() {
        return "PdfContentImporter parses data of the first page of the PDF and creates a BibTeX entry. Currently, Springer and IEEE formats are supported.";
    }
}

