/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.logic.xmp.EncryptedPdfsNotSupportedException;
import org.jabref.logic.xmp.XmpUtilReader;
import org.jabref.model.entry.BibEntry;

public class PdfEmbeddedBibFileImporter
extends Importer {
    private final BibtexParser bibtexParser;

    public PdfEmbeddedBibFileImporter(ImportFormatPreferences importFormatPreferences) {
        this.bibtexParser = new BibtexParser(importFormatPreferences);
    }

    @Override
    public boolean isRecognizedFormat(BufferedReader input) throws IOException {
        return input.readLine().startsWith("%PDF");
    }

    @Override
    public ParserResult importDatabase(BufferedReader reader) throws IOException {
        Objects.requireNonNull(reader);
        throw new UnsupportedOperationException("PdfEmbeddedBibFileImporter does not support importDatabase(BufferedReader reader).Instead use importDatabase(Path filePath, Charset defaultEncoding).");
    }

    @Override
    public ParserResult importDatabase(String data) throws IOException {
        Objects.requireNonNull(data);
        throw new UnsupportedOperationException("PdfEmbeddedBibFileImporter does not support importDatabase(String data).Instead use importDatabase(Path filePath, Charset defaultEncoding).");
    }

    @Override
    public ParserResult importDatabase(Path filePath) {
        ParserResult parserResult;
        block9: {
            PDDocument document = new XmpUtilReader().loadWithAutomaticDecryption(filePath);
            try {
                parserResult = new ParserResult(this.getEmbeddedBibFileEntries(document));
                if (document == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EncryptedPdfsNotSupportedException e) {
                    return ParserResult.fromErrorMessage(Localization.lang("Decryption not supported.", new Object[0]));
                }
                catch (IOException | ParseException e) {
                    return ParserResult.fromError(e);
                }
            }
            document.close();
        }
        return parserResult;
    }

    private List<BibEntry> getEmbeddedBibFileEntries(PDDocument document) throws IOException, ParseException {
        PDEmbeddedFilesNameTreeNode efTree;
        ArrayList<BibEntry> allParsedEntries = new ArrayList<BibEntry>();
        PDDocumentNameDictionary nameDictionary = document.getDocumentCatalog().getNames();
        if (nameDictionary != null && (efTree = nameDictionary.getEmbeddedFiles()) != null) {
            Map names = efTree.getNames();
            if (names != null) {
                allParsedEntries.addAll(this.extractAndParseFiles(names));
            } else {
                List kids = efTree.getKids();
                if (kids != null) {
                    for (PDNameTreeNode node : kids) {
                        names = node.getNames();
                        allParsedEntries.addAll(this.extractAndParseFiles(names));
                    }
                }
            }
        }
        for (PDPage page : document.getPages()) {
            for (PDAnnotation annotation : page.getAnnotations()) {
                if (!(annotation instanceof PDAnnotationFileAttachment)) continue;
                PDAnnotationFileAttachment annotationFileAttachment = (PDAnnotationFileAttachment)annotation;
                PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)annotationFileAttachment.getFile();
                allParsedEntries.addAll(this.extractAndParseFile(PdfEmbeddedBibFileImporter.getEmbeddedFile(fileSpec)));
            }
        }
        return allParsedEntries;
    }

    private List<BibEntry> extractAndParseFiles(Map<String, PDComplexFileSpecification> names) throws IOException, ParseException {
        ArrayList<BibEntry> allParsedEntries = new ArrayList<BibEntry>();
        for (Map.Entry<String, PDComplexFileSpecification> entry : names.entrySet()) {
            String filename = entry.getKey();
            FileUtil.getFileExtension(filename);
            if (!FileUtil.isBibFile(Path.of(filename, new String[0]))) continue;
            PDComplexFileSpecification fileSpec = entry.getValue();
            allParsedEntries.addAll(this.extractAndParseFile(PdfEmbeddedBibFileImporter.getEmbeddedFile(fileSpec)));
        }
        return allParsedEntries;
    }

    private List<BibEntry> extractAndParseFile(PDEmbeddedFile embeddedFile) throws IOException, ParseException {
        return this.bibtexParser.parseEntries((InputStream)embeddedFile.createInputStream());
    }

    private static PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }

    @Override
    public String getName() {
        return "PDFembeddedbibfile";
    }

    @Override
    public StandardFileType getFileType() {
        return StandardFileType.PDF;
    }

    @Override
    public String getDescription() {
        return "PdfEmbeddedBibFileImporter imports an embedded Bib-File from the PDF.";
    }
}

