/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fileformat;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.entry.field.UnknownField;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PicaXmlParser
implements Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PicaXmlParser.class);
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    @Override
    public List<BibEntry> parseEntries(InputStream inputStream) throws ParseException {
        try {
            DocumentBuilder dbuild = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            Document content = dbuild.parse(inputStream);
            return this.parseEntries(content);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new ParseException(exception);
        }
    }

    private List<BibEntry> parseEntries(Document content) {
        ArrayList<BibEntry> result = new ArrayList<BibEntry>();
        Element root = (Element)content.getElementsByTagName("zs:searchRetrieveResponse").item(0);
        Element srwrecords = this.getChild("zs:records", root);
        if (srwrecords == null) {
            return result;
        }
        List<Element> records = this.getChildren("zs:record", srwrecords);
        for (Element gvkRecord : records) {
            Element e = this.getChild("zs:recordData", gvkRecord);
            if (e == null || (e = this.getChild("record", e)) == null) continue;
            BibEntry bibEntry = this.parseEntry(e);
            result.add(bibEntry);
        }
        return result;
    }

    private BibEntry parseEntry(Element e) {
        String author = null;
        String editor = null;
        String title = null;
        String publisher = null;
        String year = null;
        String address = null;
        Object series = null;
        String edition = null;
        String isbn = null;
        String issn = null;
        String number = null;
        String pagetotal = null;
        String volume = null;
        String pages = null;
        String journal = null;
        String ppn = null;
        String booktitle = null;
        String url = null;
        String note = null;
        String source = "";
        String bibliographicGenre = "";
        String subtitle = "";
        EntryType entryType = StandardEntryType.Book;
        List<Element> datafields = this.getChildren("datafield", e);
        for (Element datafield : datafields) {
            String nachname;
            String vorname;
            String tag = datafield.getAttribute("tag");
            LOGGER.debug("tag: " + tag);
            if ("002@".equals(tag) && (bibliographicGenre = this.getSubfield("0", datafield)) == null) {
                bibliographicGenre = "";
            }
            if ("003@".equals(tag)) {
                ppn = this.getSubfield("0", datafield);
            }
            if ("028A".equals(tag)) {
                vorname = this.getSubfield("d", datafield);
                nachname = this.getSubfield("a", datafield);
                author = author == null ? "" : author.concat(" and ");
                author = author.concat(vorname + " " + nachname);
            }
            if ("028B".equals(tag)) {
                vorname = this.getSubfield("d", datafield);
                nachname = this.getSubfield("a", datafield);
                author = author == null ? "" : author.concat(" and ");
                author = author.concat(vorname + " " + nachname);
            }
            if ("028C".equals(tag)) {
                vorname = this.getSubfield("d", datafield);
                nachname = this.getSubfield("a", datafield);
                editor = editor == null ? "" : editor.concat(" and ");
                editor = editor.concat(vorname + " " + nachname);
            }
            if ("021A".equals(tag)) {
                title = this.getSubfield("a", datafield);
                subtitle = this.getSubfield("d", datafield);
            }
            if ("033A".equals(tag)) {
                publisher = this.getSubfield("n", datafield);
                address = this.getSubfield("p", datafield);
            }
            if ("011@".equals(tag)) {
                year = this.getSubfield("a", datafield);
            }
            if ("031A".equals(tag)) {
                year = this.getSubfield("j", datafield);
                volume = this.getSubfield("e", datafield);
                number = this.getSubfield("a", datafield);
                pages = this.getSubfield("h", datafield);
            }
            if ("036D".equals(tag)) {
                if (title != null) {
                    if (title.startsWith("@")) {
                        title = title.substring(1);
                    }
                    number = title;
                }
                title = this.getSubfield("a", datafield);
                subtitle = this.getSubfield("d", datafield);
                volume = this.getSubfield("l", datafield);
            }
            if ("036E".equals(tag)) {
                series = this.getSubfield("a", datafield);
                number = this.getSubfield("l", datafield);
                String kor = this.getSubfield("b", datafield);
                if (kor != null) {
                    series = (String)series + " / " + kor;
                }
            }
            if ("037A".equals(tag)) {
                note = this.getSubfield("a", datafield);
            }
            if ("032@".equals(tag)) {
                edition = this.getSubfield("a", datafield);
            }
            if ("004A".equals(tag)) {
                String isbn10 = this.getSubfield("0", datafield);
                String isbn13 = this.getSubfield("A", datafield);
                if (isbn10 != null) {
                    isbn = isbn10;
                }
                if (isbn13 != null) {
                    isbn = isbn13;
                }
            }
            if ("037C".equals(tag)) {
                String st;
                if (address == null && (address = this.getSubfield("b", datafield)) != null) {
                    address = this.removeSortCharacters(address);
                }
                if ((st = this.getSubfield("a", datafield)) != null && st.contains("Diss")) {
                    entryType = StandardEntryType.PhdThesis;
                }
            }
            if ("027D".equals(tag)) {
                journal = this.getSubfield("a", datafield);
                booktitle = this.getSubfield("a", datafield);
                address = this.getSubfield("p", datafield);
                publisher = this.getSubfield("n", datafield);
            }
            if ("034D".equals(tag) && (pagetotal = this.getSubfield("a", datafield)) != null) {
                pagetotal = pagetotal.replaceAll(" S\\.?$", "");
            }
            if ("030F".equals(tag)) {
                address = this.getSubfield("k", datafield);
                if (!"proceedings".equals(entryType.getName())) {
                    subtitle = this.getSubfield("a", datafield);
                }
                entryType = StandardEntryType.Proceedings;
            }
            if (entryType.equals(StandardEntryType.PhdThesis) && isbn != null) {
                entryType = StandardEntryType.Book;
            }
            if ("039B".equals(tag)) {
                source = this.getSubfield("8", datafield);
            }
            if ("046R".equals(tag) && (source == null || source.isEmpty())) {
                source = this.getSubfield("a", datafield);
            }
            if (!"009P".equals(tag) || !"03".equals(datafield.getAttribute("occurrence")) && !"05".equals(datafield.getAttribute("occurrence")) || url != null) continue;
            url = this.getSubfield("a", datafield);
        }
        if (source == null) {
            source = "";
        }
        if (author != null) {
            author = this.removeSortCharacters(author);
        }
        if (editor != null) {
            editor = this.removeSortCharacters(editor);
        }
        if (title != null) {
            title = this.removeSortCharacters(title);
        }
        if (subtitle != null) {
            subtitle = this.removeSortCharacters(subtitle);
        }
        if (bibliographicGenre.startsWith("As")) {
            entryType = BibEntry.DEFAULT_TYPE;
            if (source.contains("ISBN")) {
                entryType = StandardEntryType.InCollection;
            }
            if (source.contains("ZDB-ID")) {
                entryType = StandardEntryType.Article;
            }
        } else if (bibliographicGenre.isEmpty()) {
            entryType = BibEntry.DEFAULT_TYPE;
        } else if (bibliographicGenre.startsWith("O")) {
            if (bibliographicGenre.startsWith("Oa") && isbn != null) {
                entryType = StandardEntryType.Book;
            }
            if (bibliographicGenre.startsWith("Ob")) {
                entryType = StandardEntryType.Article;
            }
        }
        BibEntry result = new BibEntry(entryType);
        if (author != null) {
            result.setField(StandardField.AUTHOR, author);
        }
        if (editor != null) {
            result.setField(StandardField.EDITOR, editor);
        }
        if (title != null) {
            result.setField(StandardField.TITLE, title);
        }
        if (!StringUtil.isNullOrEmpty(subtitle)) {
            StringBuilder newSubtitle = new StringBuilder(Character.toString(Character.toUpperCase(subtitle.charAt(0))));
            if (subtitle.length() > 1) {
                newSubtitle.append(subtitle.substring(1));
            }
            result.setField(StandardField.SUBTITLE, newSubtitle.toString());
        }
        if (publisher != null) {
            result.setField(StandardField.PUBLISHER, publisher);
        }
        if (year != null) {
            result.setField(StandardField.YEAR, year);
        }
        if (address != null) {
            result.setField(StandardField.ADDRESS, address);
        }
        if (series != null) {
            result.setField(StandardField.SERIES, (String)series);
        }
        if (edition != null) {
            result.setField(StandardField.EDITION, edition);
        }
        if (isbn != null) {
            result.setField(StandardField.ISBN, isbn);
        }
        if (issn != null) {
            result.setField(StandardField.ISSN, issn);
        }
        if (number != null) {
            result.setField(StandardField.NUMBER, number);
        }
        if (pagetotal != null) {
            result.setField(StandardField.PAGETOTAL, pagetotal);
        }
        if (pages != null) {
            result.setField(StandardField.PAGES, pages);
        }
        if (volume != null) {
            result.setField(StandardField.VOLUME, volume);
        }
        if (journal != null) {
            result.setField(StandardField.JOURNAL, journal);
        }
        if (ppn != null) {
            result.setField(new UnknownField("ppn_GVK"), ppn);
        }
        if (url != null) {
            result.setField(StandardField.URL, url);
        }
        if (note != null) {
            result.setField(StandardField.NOTE, note);
        }
        if ("article".equals(entryType.getName()) && journal != null) {
            result.setField(StandardField.JOURNAL, journal);
        } else if ("incollection".equals(entryType.getName()) && booktitle != null) {
            result.setField(StandardField.BOOKTITLE, booktitle);
        }
        return result;
    }

    private String getSubfield(String a, Element datafield) {
        List<Element> subfields = this.getChildren("subfield", datafield);
        for (Element subfield : subfields) {
            if (!subfield.getAttribute("code").equalsIgnoreCase(a)) continue;
            return subfield.getTextContent();
        }
        return null;
    }

    private Element getChild(String name, Element e) {
        if (e == null) {
            return null;
        }
        NodeList children = e.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Element entry;
            Node test = children.item(i);
            if (test.getNodeType() != 1 || !(entry = (Element)test).getTagName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    private List<Element> getChildren(String name, Element e) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = e.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Element entry;
            Node test = children.item(i);
            if (test.getNodeType() != 1 || !(entry = (Element)test).getTagName().equals(name)) continue;
            result.add(entry);
        }
        return result;
    }

    private String removeSortCharacters(String input) {
        return input.replaceAll("\\@", "");
    }
}

