/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.citationkeypattern.CitationKeyGenerator;
import org.jabref.logic.citationkeypattern.CitationKeyPatternPreferences;
import org.jabref.logic.integrity.EntryChecker;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.InternalField;

public class CitationKeyDeviationChecker
implements EntryChecker {
    private final BibDatabaseContext bibDatabaseContext;
    private final CitationKeyPatternPreferences citationKeyPatternPreferences;

    public CitationKeyDeviationChecker(BibDatabaseContext bibDatabaseContext, CitationKeyPatternPreferences citationKeyPatternPreferences) {
        this.bibDatabaseContext = Objects.requireNonNull(bibDatabaseContext);
        this.citationKeyPatternPreferences = Objects.requireNonNull(citationKeyPatternPreferences);
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        String generatedKey;
        Optional<String> valuekey = entry.getCitationKey();
        if (valuekey.isEmpty()) {
            return Collections.emptyList();
        }
        String key = valuekey.get();
        if (!Objects.equals(key, generatedKey = new CitationKeyGenerator(this.bibDatabaseContext, this.citationKeyPatternPreferences).generateKey(entry))) {
            return Collections.singletonList(new IntegrityMessage(Localization.lang("Citation key deviates from generated key", new Object[0]), entry, InternalField.KEY_FIELD));
        }
        return Collections.emptyList();
    }
}

