/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jabref.logic.integrity.BooktitleChecker;
import org.jabref.logic.integrity.BracketChecker;
import org.jabref.logic.integrity.DateChecker;
import org.jabref.logic.integrity.DoiValidityChecker;
import org.jabref.logic.integrity.EditionChecker;
import org.jabref.logic.integrity.FieldChecker;
import org.jabref.logic.integrity.FileChecker;
import org.jabref.logic.integrity.HowPublishedChecker;
import org.jabref.logic.integrity.ISBNChecker;
import org.jabref.logic.integrity.ISSNChecker;
import org.jabref.logic.integrity.MonthChecker;
import org.jabref.logic.integrity.NoteChecker;
import org.jabref.logic.integrity.PagesChecker;
import org.jabref.logic.integrity.PersonNamesChecker;
import org.jabref.logic.integrity.TitleChecker;
import org.jabref.logic.integrity.UrlChecker;
import org.jabref.logic.integrity.ValidCitationKeyChecker;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.logic.integrity.YearChecker;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.FilePreferences;

public class FieldCheckers {
    private final Multimap<Field, ValueChecker> fieldChecker;

    public FieldCheckers(BibDatabaseContext databaseContext, FilePreferences filePreferences, JournalAbbreviationRepository abbreviationRepository, boolean allowIntegerEdition) {
        this.fieldChecker = FieldCheckers.getAllMap(databaseContext, filePreferences, abbreviationRepository, allowIntegerEdition);
    }

    private static Multimap<Field, ValueChecker> getAllMap(BibDatabaseContext databaseContext, FilePreferences filePreferences, JournalAbbreviationRepository abbreviationRepository, boolean allowIntegerEdition) {
        ArrayListMultimap fieldCheckers = ArrayListMultimap.create((int)50, (int)10);
        for (Field field : FieldFactory.getPersonNameFields()) {
            fieldCheckers.put((Object)field, (Object)new PersonNamesChecker(databaseContext));
        }
        fieldCheckers.put((Object)StandardField.BOOKTITLE, (Object)new BooktitleChecker());
        fieldCheckers.put((Object)StandardField.TITLE, (Object)new BracketChecker());
        fieldCheckers.put((Object)StandardField.TITLE, (Object)new TitleChecker(databaseContext));
        fieldCheckers.put((Object)StandardField.DOI, (Object)new DoiValidityChecker());
        fieldCheckers.put((Object)StandardField.EDITION, (Object)new EditionChecker(databaseContext, allowIntegerEdition));
        fieldCheckers.put((Object)StandardField.FILE, (Object)new FileChecker(databaseContext, filePreferences));
        fieldCheckers.put((Object)StandardField.HOWPUBLISHED, (Object)new HowPublishedChecker(databaseContext));
        fieldCheckers.put((Object)StandardField.ISBN, (Object)new ISBNChecker());
        fieldCheckers.put((Object)StandardField.ISSN, (Object)new ISSNChecker());
        fieldCheckers.put((Object)StandardField.MONTH, (Object)new MonthChecker(databaseContext));
        fieldCheckers.put((Object)StandardField.MONTHFILED, (Object)new MonthChecker(databaseContext));
        fieldCheckers.put((Object)StandardField.NOTE, (Object)new NoteChecker(databaseContext));
        fieldCheckers.put((Object)StandardField.PAGES, (Object)new PagesChecker(databaseContext));
        fieldCheckers.put((Object)StandardField.URL, (Object)new UrlChecker());
        fieldCheckers.put((Object)StandardField.YEAR, (Object)new YearChecker());
        fieldCheckers.put((Object)StandardField.KEY, (Object)new ValidCitationKeyChecker());
        fieldCheckers.put((Object)InternalField.KEY_FIELD, (Object)new ValidCitationKeyChecker());
        if (databaseContext.isBiblatexMode()) {
            fieldCheckers.put((Object)StandardField.DATE, (Object)new DateChecker());
            fieldCheckers.put((Object)StandardField.URLDATE, (Object)new DateChecker());
            fieldCheckers.put((Object)StandardField.EVENTDATE, (Object)new DateChecker());
            fieldCheckers.put((Object)StandardField.ORIGDATE, (Object)new DateChecker());
        }
        return fieldCheckers;
    }

    public List<FieldChecker> getAll() {
        return this.fieldChecker.entries().stream().map(pair -> new FieldChecker((Field)pair.getKey(), (ValueChecker)pair.getValue())).collect(Collectors.toList());
    }

    public Collection<ValueChecker> getForField(Field field) {
        return this.fieldChecker.get((Object)field);
    }
}

