/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.journals;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.jabref.logic.journals.Abbreviation;
import org.jabref.logic.journals.AbbreviationFormat;

public class AbbreviationParser {
    private static final Character[] DELIMITERS = new Character[]{Character.valueOf(';'), Character.valueOf(',')};
    private static final char NO_DELIMITER = '\u0000';
    private final LinkedHashSet<Abbreviation> abbreviations = new LinkedHashSet();

    void readJournalListFromFile(Path file) throws IOException {
        char delimiter = this.detectDelimiter(file);
        try (CSVParser csvParser = new CSVParser((Reader)Files.newBufferedReader(file, StandardCharsets.UTF_8), AbbreviationFormat.getCSVFormatWithDelimiter(delimiter));){
            for (CSVRecord csvRecord : csvParser) {
                String shortestUniqueAbbreviation;
                String name = csvRecord.size() > 0 ? csvRecord.get(0) : "";
                String abbreviation = csvRecord.size() > 1 ? csvRecord.get(1) : "";
                String string = shortestUniqueAbbreviation = csvRecord.size() > 2 ? csvRecord.get(2) : "";
                if (name.isEmpty() || abbreviation.isEmpty()) {
                    return;
                }
                Abbreviation abbreviationToAdd = new Abbreviation(name, abbreviation, shortestUniqueAbbreviation);
                this.abbreviations.add(abbreviationToAdd);
            }
        }
    }

    private char detectDelimiter(Path file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            String line = reader.readLine();
            if (line == null) {
                char c = '\u0000';
                return c;
            }
            char c = Arrays.stream(DELIMITERS).filter(s -> line.contains(s.toString())).findFirst().orElse(Character.valueOf('\u0000')).charValue();
            return c;
        }
    }

    public Collection<Abbreviation> getAbbreviations() {
        return this.abbreviations;
    }
}

