/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jabref.logic.cleanup.Formatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.logic.util.strings.UnicodeLigaturesMap;

public class ReplaceUnicodeLigaturesFormatter
extends Formatter
implements LayoutFormatter {
    private final Map<Pattern, String> ligaturesMap = new HashMap<Pattern, String>();

    public ReplaceUnicodeLigaturesFormatter() {
        UnicodeLigaturesMap stringMap = new UnicodeLigaturesMap();
        for (String key : stringMap.keySet()) {
            this.ligaturesMap.put(Pattern.compile(key), (String)stringMap.get(key));
        }
    }

    @Override
    public String getName() {
        return Localization.lang("Replace Unicode ligatures", new Object[0]);
    }

    @Override
    public String getKey() {
        return "replace_unicode_ligatures";
    }

    @Override
    public String format(String fieldText) {
        String result = fieldText;
        for (Pattern key : this.ligaturesMap.keySet()) {
            result = key.matcher(result).replaceAll(this.ligaturesMap.get(key));
        }
        return result;
    }

    @Override
    public String getDescription() {
        return Localization.lang("Replaces Unicode ligatures with their expanded form", new Object[0]);
    }

    @Override
    public String getExampleInput() {
        return "\u00c6neas";
    }
}

