/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.style;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.jabref.model.openoffice.ootext.OOText;
import org.jabref.model.openoffice.style.CitationMarkerNumericBibEntry;
import org.jabref.model.openoffice.style.CitationMarkerNumericEntry;
import org.jabref.model.openoffice.style.PageInfo;
import org.jabref.model.openoffice.util.OOListUtil;

class OOBibStyleGetNumCitationMarker {
    public static final int UNRESOLVED_ENTRY_NUMBER = 0;

    private OOBibStyleGetNumCitationMarker() {
    }

    private static int compareCitationMarkerNumericEntry(CitationMarkerNumericEntry a, CitationMarkerNumericEntry b) {
        int nb;
        int na = a.getNumber().orElse(0);
        int res = Integer.compare(na, nb = b.getNumber().orElse(0).intValue());
        if (res == 0) {
            res = PageInfo.comparePageInfo(a.getPageInfo(), b.getPageInfo());
        }
        return res;
    }

    public static OOText getNumCitationMarkerForBibliography(OOBibStyle style, CitationMarkerNumericBibEntry entry) {
        String bracketBefore = style.getBracketBeforeInListWithFallBack();
        String bracketAfter = style.getBracketAfterInListWithFallBack();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(style.getCitationGroupMarkupBefore());
        stringBuilder.append(bracketBefore);
        Optional<Integer> current = entry.getNumber();
        stringBuilder.append((String)(current.isPresent() ? String.valueOf(current.get()) : "??" + entry.getCitationKey()));
        stringBuilder.append(bracketAfter);
        stringBuilder.append(style.getCitationGroupMarkupAfter());
        return OOText.fromString(stringBuilder.toString());
    }

    private static void emitBlock(List<CitationMarkerNumericEntry> block, OOBibStyle style, int minGroupingCount, StringBuilder stringBuilder) {
        int blockSize = block.size();
        if (blockSize == 0) {
            throw new IllegalArgumentException("The block is empty");
        }
        if (blockSize == 1) {
            CitationMarkerNumericEntry entry = block.getFirst();
            Optional<Integer> num = entry.getNumber();
            stringBuilder.append((String)(num.isEmpty() ? "??" + entry.getCitationKey() : String.valueOf(num.get())));
            Optional<OOText> pageInfo = entry.getPageInfo();
            if (pageInfo.isPresent()) {
                stringBuilder.append(style.getPageInfoSeparator());
                stringBuilder.append(OOText.toString(pageInfo.get()));
            }
            return;
        }
        if (blockSize >= 2) {
            int j;
            if (block.stream().anyMatch(x -> x.getPageInfo().isPresent())) {
                throw new IllegalArgumentException("Found pageInfo in a block with more than one elements");
            }
            if (block.stream().anyMatch(x -> x.getNumber().isEmpty())) {
                throw new IllegalArgumentException("Found unresolved entry in a block with more than one elements");
            }
            for (j = 1; j < blockSize; ++j) {
                if (block.get(j).getNumber().get() - block.get(j - 1).getNumber().get() == 1) continue;
                throw new IllegalArgumentException("Numbers are not consecutive");
            }
            if (blockSize >= minGroupingCount) {
                int first = block.getFirst().getNumber().get();
                int last = block.get(blockSize - 1).getNumber().get();
                if (last != first + blockSize - 1) {
                    throw new IllegalArgumentException("blockSize and length of num range differ");
                }
                stringBuilder.append(first);
                stringBuilder.append(style.getGroupedNumbersSeparator());
                stringBuilder.append(last);
            } else {
                for (j = 0; j < blockSize; ++j) {
                    if (j > 0) {
                        stringBuilder.append(style.getCitationSeparator());
                    }
                    stringBuilder.append(block.get(j).getNumber().get());
                }
            }
        }
    }

    public static OOText getNumCitationMarker2(OOBibStyle style, List<CitationMarkerNumericEntry> entries, int minGroupingCount) {
        boolean joinIsDisabled = minGroupingCount <= 0;
        int nCitations = entries.size();
        String bracketBefore = style.getBracketBefore();
        String bracketAfter = style.getBracketAfter();
        List<CitationMarkerNumericEntry> sorted = OOListUtil.map(entries, e -> e);
        sorted.sort(OOBibStyleGetNumCitationMarker::compareCitationMarkerNumericEntry);
        StringBuilder stringBuilder = new StringBuilder(bracketBefore);
        boolean blocksEmitted = false;
        ArrayList<CitationMarkerNumericEntry> currentBlock = new ArrayList<CitationMarkerNumericEntry>();
        ArrayList<CitationMarkerNumericEntry> nextBlock = new ArrayList<CitationMarkerNumericEntry>();
        for (int i = 0; i < nCitations; ++i) {
            CitationMarkerNumericEntry current = sorted.get(i);
            if (current.getNumber().isPresent() && current.getNumber().get() < 0) {
                throw new IllegalArgumentException("getNumCitationMarker2: found negative number");
            }
            if (currentBlock.isEmpty()) {
                currentBlock.add(current);
            } else {
                CitationMarkerNumericEntry prev = (CitationMarkerNumericEntry)currentBlock.getLast();
                if (current.getNumber().isEmpty() || prev.getNumber().isEmpty()) {
                    nextBlock.add(current);
                } else if (joinIsDisabled) {
                    nextBlock.add(current);
                } else if (OOBibStyleGetNumCitationMarker.compareCitationMarkerNumericEntry(current, prev) != 0) {
                    if (current.getNumber().get() == prev.getNumber().get() + 1 && prev.getPageInfo().isEmpty() && current.getPageInfo().isEmpty()) {
                        currentBlock.add(current);
                    } else {
                        nextBlock.add(current);
                    }
                }
            }
            if (nextBlock.isEmpty()) continue;
            if (blocksEmitted) {
                stringBuilder.append(style.getCitationSeparator());
            }
            OOBibStyleGetNumCitationMarker.emitBlock(currentBlock, style, minGroupingCount, stringBuilder);
            blocksEmitted = true;
            currentBlock = nextBlock;
            nextBlock = new ArrayList();
        }
        if (!nextBlock.isEmpty()) {
            throw new IllegalStateException("impossible: (nextBlock.size() != 0) after loop");
        }
        if (!currentBlock.isEmpty()) {
            if (blocksEmitted) {
                stringBuilder.append(style.getCitationSeparator());
            }
            OOBibStyleGetNumCitationMarker.emitBlock(currentBlock, style, minGroupingCount, stringBuilder);
        }
        stringBuilder.append(bracketAfter);
        return OOText.fromString(stringBuilder.toString());
    }
}

