/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice.style;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.layout.LayoutFormatterPreferences;
import org.jabref.logic.openoffice.OpenOfficePreferences;
import org.jabref.logic.openoffice.style.OOBibStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleLoader {
    public static final String DEFAULT_AUTHORYEAR_STYLE_PATH = "/resource/openoffice/default_authoryear.jstyle";
    public static final String DEFAULT_NUMERICAL_STYLE_PATH = "/resource/openoffice/default_numerical.jstyle";
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleLoader.class);
    private final List<String> internalStyleFiles = Arrays.asList("/resource/openoffice/default_authoryear.jstyle", "/resource/openoffice/default_numerical.jstyle");
    private final OpenOfficePreferences openOfficePreferences;
    private final LayoutFormatterPreferences layoutFormatterPreferences;
    private final JournalAbbreviationRepository abbreviationRepository;
    private final List<OOBibStyle> internalStyles = new ArrayList<OOBibStyle>();
    private final List<OOBibStyle> externalStyles = new ArrayList<OOBibStyle>();

    public StyleLoader(OpenOfficePreferences openOfficePreferences, LayoutFormatterPreferences formatterPreferences, JournalAbbreviationRepository abbreviationRepository) {
        this.openOfficePreferences = Objects.requireNonNull(openOfficePreferences);
        this.layoutFormatterPreferences = Objects.requireNonNull(formatterPreferences);
        this.abbreviationRepository = Objects.requireNonNull(abbreviationRepository);
        this.loadInternalStyles();
        this.loadExternalStyles();
    }

    public List<OOBibStyle> getStyles() {
        ArrayList<OOBibStyle> result = new ArrayList<OOBibStyle>(this.internalStyles);
        result.addAll(this.externalStyles);
        return result;
    }

    public boolean addStyleIfValid(String filename) {
        Objects.requireNonNull(filename);
        try {
            OOBibStyle newStyle = new OOBibStyle(Path.of(filename, new String[0]), this.layoutFormatterPreferences, this.abbreviationRepository);
            if (this.externalStyles.contains(newStyle)) {
                LOGGER.info("External style file {} already existing.", (Object)filename);
            } else {
                if (newStyle.isValid()) {
                    this.externalStyles.add(newStyle);
                    this.storeExternalStyles();
                    return true;
                }
                LOGGER.error("Style with filename {} is invalid", (Object)filename);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.info("Cannot find external style file {}", (Object)filename, (Object)e);
        }
        catch (IOException e) {
            LOGGER.info("Problem reading external style file {}", (Object)filename, (Object)e);
        }
        return false;
    }

    private void loadExternalStyles() {
        this.externalStyles.clear();
        ObservableList<String> lists = this.openOfficePreferences.getExternalStyles();
        for (String filename : lists) {
            try {
                OOBibStyle style = new OOBibStyle(Path.of(filename, new String[0]), this.layoutFormatterPreferences, this.abbreviationRepository);
                if (style.isValid()) {
                    this.externalStyles.add(style);
                    continue;
                }
                LOGGER.error("Style with filename {} is invalid", (Object)filename);
            }
            catch (FileNotFoundException e) {
                LOGGER.info("Cannot find external style file {}", (Object)filename);
            }
            catch (IOException e) {
                LOGGER.info("Problem reading external style file {}", (Object)filename, (Object)e);
            }
        }
    }

    private void loadInternalStyles() {
        this.internalStyles.clear();
        for (String filename : this.internalStyleFiles) {
            try {
                this.internalStyles.add(new OOBibStyle(filename, this.layoutFormatterPreferences, this.abbreviationRepository));
            }
            catch (IOException e) {
                LOGGER.info("Problem reading internal style file {}", (Object)filename, (Object)e);
            }
        }
    }

    private void storeExternalStyles() {
        ArrayList<String> filenames = new ArrayList<String>(this.externalStyles.size());
        for (OOBibStyle style : this.externalStyles) {
            filenames.add(style.getPath());
        }
        this.openOfficePreferences.setExternalStyles(filenames);
    }

    public boolean removeStyle(OOBibStyle style) {
        Objects.requireNonNull(style);
        if (!style.isInternalStyle()) {
            boolean result = this.externalStyles.remove(style);
            this.storeExternalStyles();
            return result;
        }
        return false;
    }

    public OOBibStyle getUsedStyle() {
        String filename = this.openOfficePreferences.getCurrentStyle();
        if (filename != null) {
            for (OOBibStyle style : this.getStyles()) {
                if (!filename.equals(style.getPath())) continue;
                return style;
            }
        }
        this.openOfficePreferences.setCurrentStyle(this.internalStyles.getFirst().getPath());
        return this.internalStyles.getFirst();
    }
}

