/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.pdf;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Objects;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.text.PDFTextStripperByArea;
import org.jabref.architecture.AllowedToUseAwt;

@AllowedToUseAwt(value="org.apache.pdfbox.text.PDFTextStripperByArea.addRegion uses AWT's Rectangle to indicate a region")
public final class TextExtractor {
    private final COSArray boundingBoxes;
    private final PDPage page;

    public TextExtractor(PDPage page, COSArray boundingBoxes) {
        this.page = Objects.requireNonNull(page);
        this.boundingBoxes = Objects.requireNonNull(boundingBoxes);
    }

    public String extractMarkedText() throws IOException {
        PDFTextStripperByArea stripperByArea = new PDFTextStripperByArea();
        String markedText = "";
        int totalSegments = this.boundingBoxes.size() / 8;
        int currentSegment = 1;
        int segmentPointer = 0;
        while (currentSegment <= totalSegments) {
            try {
                stripperByArea.addRegion("markedRegion", this.calculateSegmentBoundingBox(this.boundingBoxes, segmentPointer));
                stripperByArea.extractRegions(this.page);
                markedText = markedText.concat(stripperByArea.getTextForRegion("markedRegion"));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Cannot read annotation coordinates!", e);
            }
            ++currentSegment;
            segmentPointer += 8;
        }
        return markedText.trim();
    }

    private Rectangle2D calculateSegmentBoundingBox(COSArray quadsArray, int segmentPointer) {
        float upperLeftX = this.toFloat(quadsArray.get(segmentPointer));
        float upperLeftY = this.toFloat(quadsArray.get(segmentPointer + 1));
        float upperRightX = this.toFloat(quadsArray.get(segmentPointer + 2));
        float upperRightY = this.toFloat(quadsArray.get(segmentPointer + 3));
        float lowerLeftX = this.toFloat(quadsArray.get(segmentPointer + 4));
        float lowerLeftY = this.toFloat(quadsArray.get(segmentPointer + 5));
        PDRectangle pageSize = this.page.getMediaBox();
        float ulx = upperLeftX - 1.0f;
        float uly = pageSize.getHeight() - upperLeftY;
        float width = upperRightX - lowerLeftX;
        float height = upperRightY - lowerLeftY;
        return new Rectangle2D.Float(ulx, uly, width, height);
    }

    private float toFloat(Object cosNumber) {
        if (cosNumber instanceof COSFloat) {
            COSFloat float1 = (COSFloat)cosNumber;
            return float1.floatValue();
        }
        if (cosNumber instanceof COSInteger) {
            COSInteger integer = (COSInteger)cosNumber;
            return integer.floatValue();
        }
        throw new IllegalArgumentException("The number type of the annotation is not supported!");
    }
}

