/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.preferences;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.jabref.model.entry.field.Field;

public class TimestampPreferences {
    private final BooleanProperty addCreationDate;
    private final BooleanProperty addModificationDate;
    private final boolean updateTimestamp;
    private final Field timestampField;
    private final String timestampFormat;

    public TimestampPreferences(boolean addCreationDate, boolean modifyTimestamp, boolean updateTimestamp, Field timestampField, String timestampFormat) {
        this.addCreationDate = new SimpleBooleanProperty(addCreationDate);
        this.addModificationDate = new SimpleBooleanProperty(modifyTimestamp);
        this.updateTimestamp = updateTimestamp;
        this.timestampField = timestampField;
        this.timestampFormat = timestampFormat;
    }

    public String now() {
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS));
    }

    public boolean shouldAddCreationDate() {
        return this.addCreationDate.get();
    }

    public BooleanProperty addCreationDateProperty() {
        return this.addCreationDate;
    }

    public void setAddCreationDate(boolean addCreationDate) {
        this.addCreationDate.set(addCreationDate);
    }

    public boolean shouldAddModificationDate() {
        return this.addModificationDate.get();
    }

    public BooleanProperty addModificationDateProperty() {
        return this.addModificationDate;
    }

    public void setAddModificationDate(boolean addModificationDate) {
        this.addModificationDate.set(addModificationDate);
    }

    public boolean shouldUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public Field getTimestampField() {
        return this.timestampField;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }
}

