/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.quality.consistency;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.jabref.logic.quality.consistency.BibliographyConsistencyCheck;
import org.jabref.logic.quality.consistency.BibliographyConsistencyCheckResultWriter;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.Field;

public class BibliographyConsistencyCheckResultCsvWriter
extends BibliographyConsistencyCheckResultWriter {
    private CSVPrinter csvPrinter;

    public BibliographyConsistencyCheckResultCsvWriter(BibliographyConsistencyCheck.Result result, Writer writer) {
        super(result, writer);
    }

    public BibliographyConsistencyCheckResultCsvWriter(BibliographyConsistencyCheck.Result result, Writer writer, BibEntryTypesManager entryTypesManager, BibDatabaseMode bibDatabaseMode) {
        super(result, writer, entryTypesManager, bibDatabaseMode);
    }

    @Override
    public void writeFindings() throws IOException {
        this.csvPrinter = new CSVPrinter((Appendable)this.writer, CSVFormat.DEFAULT);
        this.csvPrinter.printRecord((Iterable)this.columnNames);
        super.writeFindings();
    }

    @Override
    protected void writeBibEntry(BibEntry bibEntry, String entryType, Set<Field> requiredFields, Set<Field> optionalFields) throws IOException {
        List<String> theRecord = this.getFindingsAsList(bibEntry, entryType, requiredFields, optionalFields);
        this.csvPrinter.printRecord(theRecord);
    }

    @Override
    public void close() throws IOException {
        this.csvPrinter.close();
    }
}

