/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.shared;

import java.sql.SQLException;
import java.util.Map;
import org.jabref.logic.shared.DBMSProcessor;
import org.jabref.logic.shared.DatabaseConnection;

public class MySQLProcessor
extends DBMSProcessor {
    private Integer VERSION_DB_STRUCT_DEFAULT = -1;
    private Integer CURRENT_VERSION_DB_STRUCT = 1;

    public MySQLProcessor(DatabaseConnection connection) {
        super(connection);
    }

    @Override
    public void setUp() throws SQLException {
        this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS `JABREF_ENTRY` (`SHARED_ID` INT(11) NOT NULL PRIMARY KEY AUTO_INCREMENT, `TYPE` VARCHAR(255) NOT NULL, `VERSION` INT(11) DEFAULT 1)");
        this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS `JABREF_FIELD` (`ENTRY_SHARED_ID` INT(11) NOT NULL, `NAME` VARCHAR(255) NOT NULL, `VALUE` TEXT DEFAULT NULL, FOREIGN KEY (`ENTRY_SHARED_ID`) REFERENCES `JABREF_ENTRY`(`SHARED_ID`) ON DELETE CASCADE)");
        this.connection.createStatement().executeUpdate("CREATE TABLE IF NOT EXISTS `JABREF_METADATA` (`KEY` varchar(255) NOT NULL,`VALUE` text NOT NULL)");
        Map<String, String> metadata = this.getSharedMetaData();
        if (metadata.get("VersionDBStructure") != null) {
            try {
                this.VERSION_DB_STRUCT_DEFAULT = Integer.valueOf(metadata.get("VersionDBStructure"));
            }
            catch (Exception e) {
                LOGGER.warn("[VERSION_DB_STRUCT_DEFAULT] not Integer!");
            }
        } else {
            LOGGER.warn("[VERSION_DB_STRUCT_DEFAULT] not Exist!");
        }
        if (this.VERSION_DB_STRUCT_DEFAULT < this.CURRENT_VERSION_DB_STRUCT) {
            if (this.CURRENT_VERSION_DB_STRUCT == 1 && this.checkTableAvailability("ENTRY", "FIELD", "METADATA")) {
                LOGGER.info("Migrating from VersionDBStructure == 0");
                this.connection.createStatement().executeUpdate("INSERT INTO " + this.escape_Table("ENTRY") + " SELECT * FROM `ENTRY`");
                this.connection.createStatement().executeUpdate("INSERT INTO " + this.escape_Table("FIELD") + " SELECT * FROM `FIELD`");
                this.connection.createStatement().executeUpdate("INSERT INTO " + this.escape_Table("METADATA") + " SELECT * FROM `METADATA`");
                metadata = this.getSharedMetaData();
            }
            metadata.put("VersionDBStructure", this.CURRENT_VERSION_DB_STRUCT.toString());
            this.setSharedMetaData(metadata);
        }
    }

    @Override
    String escape(String expression) {
        return "`" + expression + "`";
    }

    @Override
    String escape_Table(String expression) {
        return this.escape("JABREF_" + expression);
    }

    @Override
    Integer getCURRENT_VERSION_DB_STRUCT() {
        return this.CURRENT_VERSION_DB_STRUCT;
    }
}

