/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.shared.listener;

import java.sql.SQLException;
import org.jabref.logic.shared.DBMSProcessor;
import org.jabref.logic.shared.DBMSSynchronizer;
import org.postgresql.PGConnection;
import org.postgresql.PGNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresSQLNotificationListener
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresSQLNotificationListener.class);
    private final DBMSSynchronizer dbmsSynchronizer;
    private final PGConnection pgConnection;
    private volatile boolean stop;

    public PostgresSQLNotificationListener(DBMSSynchronizer dbmsSynchronizer, PGConnection pgConnection) {
        this.dbmsSynchronizer = dbmsSynchronizer;
        this.pgConnection = pgConnection;
    }

    @Override
    public void run() {
        this.stop = false;
        try {
            while (!this.stop) {
                PGNotification[] notifications = this.pgConnection.getNotifications();
                if (notifications != null) {
                    for (PGNotification notification : notifications) {
                        if (notification.getName().equals(DBMSProcessor.PROCESSOR_ID)) continue;
                        this.dbmsSynchronizer.pullChanges();
                    }
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException | SQLException exception) {
            LOGGER.error("Error while listening for updates to PostgresSQL", (Throwable)exception);
        }
    }

    public void stop() {
        this.stop = true;
    }
}

