/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.xmp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.xml.XmpSerializer;
import org.jabref.logic.formatter.casechanger.UnprotectTermsFormatter;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.logic.xmp.DublinCoreExtractor;
import org.jabref.logic.xmp.EncryptedPdfsNotSupportedException;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.logic.xmp.XmpUtilShared;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.schema.DublinCoreSchemaCustom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class XmpUtilWriter {
    private static final String XMP_BEGIN_END_TAG = "?xpacket";
    private static final Logger LOGGER = LoggerFactory.getLogger(XmpUtilWriter.class);
    private final UnprotectTermsFormatter unprotectTermsFormatter = new UnprotectTermsFormatter();
    private final XmpPreferences xmpPreferences;

    public XmpUtilWriter(XmpPreferences xmpPreferences) {
        this.xmpPreferences = xmpPreferences;
    }

    public void writeXmp(Path file, BibEntry entry, BibDatabase database) throws IOException, TransformerException {
        this.writeXmp(file, List.of(entry), database);
    }

    private void writeToDCSchema(DublinCoreSchema dcSchema, BibEntry entry, BibDatabase database) {
        BibEntry resolvedEntry = this.getDefaultOrDatabaseEntry(entry, database);
        this.writeToDCSchema(dcSchema, resolvedEntry);
    }

    private void writeToDCSchema(DublinCoreSchema dcSchema, BibEntry entry) {
        DublinCoreExtractor dcExtractor = new DublinCoreExtractor(dcSchema, this.xmpPreferences, entry);
        dcExtractor.fillDublinCoreSchema();
    }

    private void writeDublinCore(PDDocument document, List<BibEntry> entries, BibDatabase database) throws IOException, TransformerException {
        XMPMetadata meta;
        List<BibEntry> resolvedEntries = database == null ? entries : database.resolveForStrings(entries, false);
        PDDocumentCatalog catalog = document.getDocumentCatalog();
        PDMetadata metaRaw = catalog.getMetadata();
        if (metaRaw == null) {
            meta = XMPMetadata.createXMPMetadata();
        } else {
            try {
                meta = XmpUtilShared.parseXmpMetadata((InputStream)metaRaw.createInputStream());
            }
            catch (IOException e) {
                meta = XMPMetadata.createXMPMetadata();
            }
        }
        meta.removeSchema((XMPSchema)meta.getDublinCoreSchema());
        for (BibEntry entry : resolvedEntries) {
            DublinCoreSchema dcSchema = DublinCoreSchemaCustom.copyDublinCoreSchema(meta.createAndAddDublinCoreSchema());
            this.writeToDCSchema(dcSchema, entry, null);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XmpSerializer serializer = new XmpSerializer();
        serializer.serialize(meta, (OutputStream)os, true);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        PDMetadata metadataStream = new PDMetadata(document, (InputStream)is);
        catalog.setMetadata(metadataStream);
    }

    private String generateXmpStringWithXmpDeclaration(List<BibEntry> entries) {
        String string;
        XMPMetadata meta = XMPMetadata.createXMPMetadata();
        for (BibEntry entry : entries) {
            DublinCoreSchema dcSchema = meta.createAndAddDublinCoreSchema();
            this.writeToDCSchema(dcSchema, entry);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            XmpSerializer serializer = new XmpSerializer();
            serializer.serialize(meta, (OutputStream)os, true);
            string = os.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TransformerException e) {
                LOGGER.warn("Transformation into XMP not possible: " + e.getMessage(), (Throwable)e);
                return "";
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn("Unsupported encoding to UTF-8 of bib entries in XMP metadata.", (Throwable)e);
                return "";
            }
            catch (IOException e) {
                LOGGER.warn("IO Exception thrown by closing the output stream.", (Throwable)e);
                return "";
            }
        }
        os.close();
        return string;
    }

    public String generateXmpStringWithoutXmpDeclaration(List<BibEntry> entries) {
        String xmpContent = this.generateXmpStringWithXmpDeclaration(entries);
        Predicate<String> isBeginOrEndTag = s -> s.contains(XMP_BEGIN_END_TAG);
        return Arrays.stream(xmpContent.split(System.lineSeparator())).filter(isBeginOrEndTag.negate()).collect(Collectors.joining(System.lineSeparator()));
    }

    /*
     * Exception decompiling
     */
    private void writeDocumentInformation(PDDocument document, BibEntry entry, BibDatabase database) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=6,496
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void writeXmp(Path path, List<BibEntry> bibtexEntries, BibDatabase database) throws IOException, TransformerException {
        List<BibEntry> resolvedEntries = database == null ? bibtexEntries : database.resolveForStrings(bibtexEntries, false);
        Path newFile = Files.createTempFile("JabRef", "pdf", new FileAttribute[0]);
        try (PDDocument document = Loader.loadPDF((File)path.toFile());){
            if (document.isEncrypted()) {
                throw new EncryptedPdfsNotSupportedException();
            }
            if (!resolvedEntries.isEmpty()) {
                this.writeDocumentInformation(document, resolvedEntries.getFirst(), null);
                this.writeDublinCore(document, resolvedEntries, null);
            }
            try {
                document.save(newFile.toFile());
                FileUtil.copyFile(newFile, path, true);
            }
            catch (IOException e) {
                LOGGER.debug("Could not write XMP metadata", (Throwable)e);
                throw new TransformerException("Could not write XMP metadata: " + e.getLocalizedMessage(), e);
            }
        }
        Files.delete(newFile);
    }

    private BibEntry getDefaultOrDatabaseEntry(BibEntry defaultEntry, BibDatabase database) {
        if (database == null) {
            return defaultEntry;
        }
        return database.resolveForStrings(defaultEntry, false);
    }

    private static /* synthetic */ void lambda$writeDocumentInformation$1(PDDocumentInformation di, Field field, String val) {
        di.setCustomMetadataValue("bibtex/" + String.valueOf(field), val);
    }
}

