/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Optional;
import org.jabref.model.strings.StringUtil;

public enum Month {
    JANUARY("January", "jan", 1),
    FEBRUARY("February", "feb", 2),
    MARCH("March", "mar", 3),
    APRIL("April", "apr", 4),
    MAY("May", "may", 5),
    JUNE("June", "jun", 6),
    JULY("July", "jul", 7),
    AUGUST("August", "aug", 8),
    SEPTEMBER("September", "sep", 9),
    OCTOBER("October", "oct", 10),
    NOVEMBER("November", "nov", 11),
    DECEMBER("December", "dec", 12);

    private final String fullName;
    private final String shortName;
    private final String twoDigitNumber;
    private final int number;

    private Month(String fullName, String shortName, int number) {
        this.fullName = fullName;
        this.shortName = shortName;
        this.twoDigitNumber = "%02d".formatted(number);
        this.number = number;
    }

    public static Optional<Month> getMonthByNumber(int number) {
        for (Month month : Month.values()) {
            if (month.number != number) continue;
            return Optional.of(month);
        }
        return Optional.empty();
    }

    public static Optional<Month> getMonthByShortName(String shortName) {
        for (Month month : Month.values()) {
            if (!month.shortName.equalsIgnoreCase(shortName)) continue;
            return Optional.of(month);
        }
        return Optional.empty();
    }

    public static Optional<Month> parse(String value) {
        Optional<Month> month;
        if (StringUtil.isBlank(value)) {
            return Optional.empty();
        }
        String testString = value.replace("#", "").trim();
        if (testString.length() > 3) {
            testString = testString.substring(0, 3);
        }
        if ((month = Month.getMonthByShortName(testString)).isPresent()) {
            return month;
        }
        month = Month.parseGermanShortMonth(testString);
        if (month.isPresent()) {
            return month;
        }
        try {
            int number = Integer.parseInt(value);
            return Month.getMonthByNumber(number);
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    static Optional<Month> parseGermanShortMonth(String value) {
        switch (value = value.toLowerCase()) {
            case "jan": 
            case "januar": {
                return Month.getMonthByNumber(1);
            }
            case "feb": 
            case "februar": {
                return Month.getMonthByNumber(2);
            }
            case "m\u00e4r": 
            case "mae": 
            case "m\u00e4rz": 
            case "maerz": {
                return Month.getMonthByNumber(3);
            }
            case "apr": 
            case "april": {
                return Month.getMonthByNumber(4);
            }
            case "mai": {
                return Month.getMonthByNumber(5);
            }
            case "jun": 
            case "juni": {
                return Month.getMonthByNumber(6);
            }
            case "jul": 
            case "juli": {
                return Month.getMonthByNumber(7);
            }
            case "aug": 
            case "august": {
                return Month.getMonthByNumber(8);
            }
            case "sep": 
            case "september": {
                return Month.getMonthByNumber(9);
            }
            case "okt": 
            case "oktober": {
                return Month.getMonthByNumber(10);
            }
            case "nov": 
            case "november": {
                return Month.getMonthByNumber(11);
            }
            case "dez": 
            case "dezember": {
                return Month.getMonthByNumber(12);
            }
        }
        return Optional.empty();
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getJabRefFormat() {
        return "#%s#".formatted(this.shortName);
    }

    public int getNumber() {
        return this.number;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getTwoDigitNumber() {
        return this.twoDigitNumber;
    }
}

