/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.event;

import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.event.EntriesEventSource;
import org.jabref.model.entry.event.EntryChangedEvent;
import org.jabref.model.entry.field.Field;

public class FieldChangedEvent
extends EntryChangedEvent {
    private final Field field;
    private final String newValue;
    private final String oldValue;
    private int majorCharacterChange = 0;

    public FieldChangedEvent(BibEntry bibEntry, Field field, String newValue, String oldValue, EntriesEventSource location) {
        super(bibEntry, location);
        this.field = field;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.majorCharacterChange = this.computeMajorCharacterChange(oldValue, newValue);
    }

    public FieldChangedEvent(BibEntry bibEntry, Field field, String newValue, String oldValue) {
        super(bibEntry);
        this.field = field;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.majorCharacterChange = this.computeMajorCharacterChange(oldValue, newValue);
    }

    public FieldChangedEvent(FieldChange fieldChange, EntriesEventSource location) {
        super(fieldChange.getEntry(), location);
        this.field = fieldChange.getField();
        this.newValue = fieldChange.getNewValue();
        this.oldValue = fieldChange.getOldValue();
        this.majorCharacterChange = this.computeMajorCharacterChange(this.oldValue, this.newValue);
    }

    public FieldChangedEvent(FieldChange fieldChange) {
        this(fieldChange, EntriesEventSource.LOCAL);
    }

    private int computeMajorCharacterChange(String oldValue, String newValue) {
        if (oldValue == newValue) {
            return 0;
        }
        if (oldValue == null && newValue != null) {
            return newValue.length();
        }
        if (newValue == null && oldValue != null) {
            return oldValue.length();
        }
        if (oldValue.length() == newValue.length() && !oldValue.equals(newValue)) {
            return newValue.length();
        }
        return Math.abs(newValue.length() - oldValue.length());
    }

    public Field getField() {
        return this.field;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public int getMajorCharacterChange() {
        return this.majorCharacterChange;
    }
}

