/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.types.BiblatexApaEntryType;
import org.jabref.model.entry.types.BiblatexEntryTypeDefinitions;
import org.jabref.model.entry.types.BiblatexSoftwareEntryType;
import org.jabref.model.entry.types.BibtexEntryTypeDefinitions;
import org.jabref.model.entry.types.EntryType;
import org.jabref.model.entry.types.IEEETranEntryType;
import org.jabref.model.entry.types.StandardEntryType;
import org.jabref.model.entry.types.SystematicLiteratureReviewStudyEntryType;
import org.jabref.model.entry.types.UnknownEntryType;

public class EntryTypeFactory {
    private EntryTypeFactory() {
    }

    public static boolean nameAndFieldsAreEqual(BibEntryType type1, BibEntryType type2) {
        if (type1 == null && type2 == null) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        return Objects.equals(type1.getType(), type2.getType()) && Objects.equals(type1.getRequiredFields(), type2.getRequiredFields()) && Objects.equals(type1.getOptionalFields(), type2.getOptionalFields()) && Objects.equals(type1.getDetailOptionalFields(), type2.getDetailOptionalFields());
    }

    public static boolean isExclusiveBiblatex(EntryType type) {
        return EntryTypeFactory.isBiblatex(type) && !EntryTypeFactory.isBibtex(type);
    }

    private static boolean isBibtex(EntryType type) {
        return BibtexEntryTypeDefinitions.ALL.stream().anyMatch(bibEntryType -> bibEntryType.getType().equals(type));
    }

    private static boolean isBiblatex(EntryType type) {
        return BiblatexEntryTypeDefinitions.ALL.stream().anyMatch(bibEntryType -> bibEntryType.getType().equals(type));
    }

    public static EntryType parse(String typeName) {
        ArrayList<StandardEntryType> types = new ArrayList<StandardEntryType>(Arrays.asList(StandardEntryType.values()));
        types.addAll(Arrays.asList(IEEETranEntryType.values()));
        types.addAll(Arrays.asList(BiblatexSoftwareEntryType.values()));
        types.addAll(Arrays.asList(BiblatexApaEntryType.values()));
        types.addAll(Arrays.asList(SystematicLiteratureReviewStudyEntryType.values()));
        return types.stream().filter(type -> type.getName().equals(typeName.toLowerCase(Locale.ENGLISH))).findFirst().orElse(new UnknownEntryType(typeName));
    }
}

