/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.groups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.groups.AbstractGroup;
import org.jabref.model.groups.GroupHierarchyType;
import org.jabref.model.groups.WordKeywordGroup;

public class ExplicitGroup
extends WordKeywordGroup {
    private final List<String> legacyEntryKeys = new ArrayList<String>();

    public ExplicitGroup(String name, GroupHierarchyType context, Character keywordSeparator) {
        super(name, context, StandardField.GROUPS, name, true, keywordSeparator, true);
    }

    public void addLegacyEntryKey(String key) {
        this.legacyEntryKeys.add(key);
    }

    @Override
    public AbstractGroup deepCopy() {
        ExplicitGroup copy = new ExplicitGroup(this.getName(), this.getHierarchicalContext(), this.keywordSeparator);
        copy.legacyEntryKeys.addAll(this.legacyEntryKeys);
        return copy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExplicitGroup)) {
            return false;
        }
        ExplicitGroup other = (ExplicitGroup)o;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals((Object)this.getHierarchicalContext(), (Object)other.getHierarchicalContext()) && Objects.equals(this.getIconName(), other.getIconName()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getColor(), other.getColor()) && Objects.equals(this.isExpanded(), other.isExpanded()) && Objects.equals(this.getLegacyEntryKeys(), other.getLegacyEntryKeys());
    }

    public void clearLegacyEntryKeys() {
        this.legacyEntryKeys.clear();
    }

    public List<String> getLegacyEntryKeys() {
        return Collections.unmodifiableList(this.legacyEntryKeys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name.getValue(), this.context, this.legacyEntryKeys, this.iconName, this.color, this.description, this.isExpanded});
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

