/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.rangesort;

import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import java.util.ArrayList;
import java.util.List;
import org.jabref.model.openoffice.rangesort.RangeHolder;
import org.jabref.model.openoffice.rangesort.RangeOverlap;
import org.jabref.model.openoffice.rangesort.RangeOverlapKind;
import org.jabref.model.openoffice.uno.UnoCast;
import org.jabref.model.openoffice.uno.UnoTextRange;
import org.jabref.model.openoffice.util.OOTuple3;

public class RangeOverlapBetween {
    private RangeOverlapBetween() {
    }

    public static <V extends RangeHolder> List<RangeOverlap<V>> findFirst(XTextDocument doc, List<V> fewHolders, List<V> manyHolders, boolean includeTouching) {
        ArrayList<RangeOverlap<V>> result = new ArrayList<RangeOverlap<V>>();
        if (fewHolders.isEmpty()) {
            return result;
        }
        ArrayList<OOTuple3<XText, XTextRangeCompare, RangeHolder>> fewTuples = new ArrayList<OOTuple3<XText, XTextRangeCompare, RangeHolder>>(fewHolders.size());
        for (RangeHolder aHolder : fewHolders) {
            XText aText = aHolder.getRange().getText();
            fewTuples.add(new OOTuple3<XText, XTextRangeCompare, RangeHolder>(aText, UnoCast.cast(XTextRangeCompare.class, aText).get(), aHolder));
        }
        for (RangeHolder bHolder : manyHolders) {
            XTextRange bRange = bHolder.getRange();
            XText bText = bRange.getText();
            XTextRange bRangeStart = bRange.getStart();
            XTextRange bRangeEnd = bRange.getEnd();
            for (OOTuple3 oOTuple3 : fewTuples) {
                boolean touching;
                int baEndToStart;
                int abEndToStart;
                XText aText = (XText)oOTuple3.a;
                XTextRangeCompare cmp = (XTextRangeCompare)oOTuple3.b;
                RangeHolder aHolder = (RangeHolder)oOTuple3.c;
                XTextRange aRange = aHolder.getRange();
                if (aText != bText || (abEndToStart = UnoTextRange.compareStartsUnsafe(cmp, aRange.getEnd(), bRangeStart)) < 0 || !includeTouching && abEndToStart == 0 || (baEndToStart = UnoTextRange.compareStartsUnsafe(cmp, bRangeEnd, aRange.getStart())) < 0 || !includeTouching && baEndToStart == 0) continue;
                boolean equal = UnoTextRange.compareStartsThenEndsUnsafe(cmp, aRange, bRange) == 0;
                boolean bl = touching = abEndToStart == 0 || baEndToStart == 0;
                RangeOverlapKind kind = equal ? RangeOverlapKind.EQUAL_RANGE : (touching ? RangeOverlapKind.TOUCH : RangeOverlapKind.OVERLAP);
                ArrayList<RangeHolder> valuesForOverlappingRanges = new ArrayList<RangeHolder>();
                valuesForOverlappingRanges.add(aHolder);
                valuesForOverlappingRanges.add(bHolder);
                result.add(new RangeOverlap(kind, valuesForOverlappingRanges));
                return result;
            }
        }
        return result;
    }
}

