/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.style;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.openoffice.style.Citation;
import org.jabref.model.openoffice.style.CitationGroup;
import org.jabref.model.openoffice.style.CitationGroupId;
import org.jabref.model.openoffice.style.CitationPath;
import org.jabref.model.openoffice.style.CitedKey;
import org.jabref.model.openoffice.style.CitedKeys;
import org.jabref.model.openoffice.util.OOListUtil;
import org.jabref.model.openoffice.util.OOPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitationGroups {
    private static final Logger LOGGER = LoggerFactory.getLogger(CitationGroups.class);
    private final Map<CitationGroupId, CitationGroup> citationGroupsUnordered;
    private Optional<List<CitationGroupId>> globalOrder;
    private Optional<CitedKeys> bibliography;

    public CitationGroups(Map<CitationGroupId, CitationGroup> citationGroups) {
        this.citationGroupsUnordered = citationGroups;
        this.globalOrder = Optional.empty();
        this.bibliography = Optional.empty();
    }

    public int numberOfCitationGroups() {
        return this.citationGroupsUnordered.size();
    }

    public <T> void distributeToCitations(List<CitationPath> where, Consumer<OOPair<Citation, T>> fun, T value) {
        for (CitationPath p : where) {
            CitationGroup group = this.citationGroupsUnordered.get(p.group);
            if (group == null) {
                LOGGER.warn("CitationGroups.distributeToCitations: group missing");
                continue;
            }
            Citation cit = group.citationsInStorageOrder.get(p.storageIndexInGroup);
            fun.accept(new OOPair<Citation, T>(cit, value));
        }
    }

    public void lookupCitations(List<BibDatabase> databases) {
        CitedKeys cks = this.getCitedKeysUnordered();
        cks.lookupInDatabases(databases);
        cks.distributeLookupResults(this);
    }

    public List<CitationGroup> getCitationGroupsUnordered() {
        return new ArrayList<CitationGroup>(this.citationGroupsUnordered.values());
    }

    public List<CitationGroup> getCitationGroupsInGlobalOrder() {
        if (this.globalOrder.isEmpty()) {
            throw new IllegalStateException("getCitationGroupsInGlobalOrder: not ordered yet");
        }
        return OOListUtil.map(this.globalOrder.get(), this.citationGroupsUnordered::get);
    }

    public void setGlobalOrder(List<CitationGroupId> globalOrder) {
        Objects.requireNonNull(globalOrder);
        if (globalOrder.size() != this.numberOfCitationGroups()) {
            throw new IllegalStateException("setGlobalOrder: globalOrder.size() != numberOfCitationGroups()");
        }
        this.globalOrder = Optional.of(globalOrder);
        for (int i = 0; i < globalOrder.size(); ++i) {
            CitationGroupId groupId = globalOrder.get(i);
            this.citationGroupsUnordered.get(groupId).setIndexInGlobalOrder(Optional.of(i));
        }
    }

    public boolean hasGlobalOrder() {
        return this.globalOrder.isPresent();
    }

    public void imposeLocalOrder(Comparator<BibEntry> entryComparator) {
        for (CitationGroup group : this.citationGroupsUnordered.values()) {
            group.imposeLocalOrder(entryComparator);
        }
    }

    public CitedKeys getCitedKeysUnordered() {
        LinkedHashMap<String, CitedKey> res = new LinkedHashMap<String, CitedKey>();
        for (CitationGroup group : this.citationGroupsUnordered.values()) {
            int storageIndexInGroup = 0;
            for (Citation cit : group.citationsInStorageOrder) {
                String key = cit.citationKey;
                CitationPath path = new CitationPath(group.groupId, storageIndexInGroup);
                if (res.containsKey(key)) {
                    res.get(key).addPath(path, cit);
                } else {
                    res.put(key, new CitedKey(key, path, cit));
                }
                ++storageIndexInGroup;
            }
        }
        return new CitedKeys(res);
    }

    public CitedKeys getCitedKeysSortedInOrderOfAppearance() {
        if (!this.hasGlobalOrder()) {
            throw new IllegalStateException("getSortedCitedKeys: no globalOrder");
        }
        LinkedHashMap<String, CitedKey> res = new LinkedHashMap<String, CitedKey>();
        for (CitationGroup group : this.getCitationGroupsInGlobalOrder()) {
            for (int i : group.getLocalOrder()) {
                Citation cit = group.citationsInStorageOrder.get(i);
                String citationKey = cit.citationKey;
                CitationPath path = new CitationPath(group.groupId, i);
                if (res.containsKey(citationKey)) {
                    res.get(citationKey).addPath(path, cit);
                    continue;
                }
                res.put(citationKey, new CitedKey(citationKey, path, cit));
            }
        }
        return new CitedKeys(res);
    }

    public Optional<CitedKeys> getBibliography() {
        return this.bibliography;
    }

    public List<String> getUnresolvedKeys() {
        CitedKeys bib = this.getBibliography().orElse(this.getCitedKeysUnordered());
        ArrayList<String> unresolvedKeys = new ArrayList<String>();
        for (CitedKey ck : bib.values()) {
            if (!ck.getLookupResult().isEmpty()) continue;
            unresolvedKeys.add(ck.citationKey);
        }
        return unresolvedKeys;
    }

    public void createNumberedBibliographySortedInOrderOfAppearance() {
        if (this.bibliography.isPresent()) {
            throw new IllegalStateException("createNumberedBibliographySortedInOrderOfAppearance: already have a bibliography");
        }
        CitedKeys citedKeys = this.getCitedKeysSortedInOrderOfAppearance();
        citedKeys.numberCitedKeysInCurrentOrder();
        citedKeys.distributeNumbers(this);
        this.bibliography = Optional.of(citedKeys);
    }

    public void createPlainBibliographySortedByComparator(Comparator<BibEntry> entryComparator) {
        if (this.bibliography.isPresent()) {
            throw new IllegalStateException("createPlainBibliographySortedByComparator: already have a bibliography");
        }
        CitedKeys citedKeys = this.getCitedKeysUnordered();
        citedKeys.sortByComparator(entryComparator);
        this.bibliography = Optional.of(citedKeys);
    }

    public void createNumberedBibliographySortedByComparator(Comparator<BibEntry> entryComparator) {
        if (this.bibliography.isPresent()) {
            throw new IllegalStateException("createNumberedBibliographySortedByComparator: already have a bibliography");
        }
        CitedKeys citedKeys = this.getCitedKeysUnordered();
        citedKeys.sortByComparator(entryComparator);
        citedKeys.numberCitedKeysInCurrentOrder();
        citedKeys.distributeNumbers(this);
        this.bibliography = Optional.of(citedKeys);
    }

    public Optional<CitationGroup> getCitationGroup(CitationGroupId groupId) {
        CitationGroup group = this.citationGroupsUnordered.get(groupId);
        return Optional.ofNullable(group);
    }

    public boolean citationGroupsProvideReferenceMarkNameForLinking() {
        for (CitationGroup group : this.citationGroupsUnordered.values()) {
            if (!group.getReferenceMarkNameForLinking().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void afterCreateCitationGroup(CitationGroup group) {
        this.citationGroupsUnordered.put(group.groupId, group);
        this.globalOrder = Optional.empty();
        this.bibliography = Optional.empty();
    }

    public void afterRemoveCitationGroup(CitationGroup group) {
        this.citationGroupsUnordered.remove(group.groupId);
        this.globalOrder.map(l -> l.remove(group.groupId));
        this.bibliography = Optional.empty();
    }
}

