/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.uno;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNamed;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XTextDocument;
import java.util.Optional;
import org.jabref.model.openoffice.uno.UnoCast;

public class UnoStyle {
    public static final String CHARACTER_STYLES = "CharacterStyles";
    public static final String PARAGRAPH_STYLES = "ParagraphStyles";

    private UnoStyle() {
    }

    private static Optional<XStyle> getStyleFromFamily(XTextDocument doc, String familyName, String styleName) throws WrappedTargetException {
        XNameContainer xFamily;
        XStyleFamiliesSupplier fss = UnoCast.cast(XStyleFamiliesSupplier.class, doc).get();
        XNameAccess families = UnoCast.cast(XNameAccess.class, fss.getStyleFamilies()).get();
        try {
            xFamily = UnoCast.cast(XNameContainer.class, families.getByName(familyName)).get();
        }
        catch (NoSuchElementException ex) {
            String msg = "Style family name '%s' is not recognized".formatted(familyName);
            throw new IllegalArgumentException(msg, ex);
        }
        try {
            Object style = xFamily.getByName(styleName);
            return UnoCast.cast(XStyle.class, style);
        }
        catch (NoSuchElementException ex) {
            return Optional.empty();
        }
    }

    public static Optional<XStyle> getParagraphStyle(XTextDocument doc, String styleName) throws WrappedTargetException {
        return UnoStyle.getStyleFromFamily(doc, PARAGRAPH_STYLES, styleName);
    }

    public static Optional<XStyle> getCharacterStyle(XTextDocument doc, String styleName) throws WrappedTargetException {
        return UnoStyle.getStyleFromFamily(doc, CHARACTER_STYLES, styleName);
    }

    public static Optional<String> getInternalNameOfStyle(XTextDocument doc, String familyName, String name) throws WrappedTargetException {
        return UnoStyle.getStyleFromFamily(doc, familyName, name).map(XNamed::getName);
    }

    public static Optional<String> getInternalNameOfParagraphStyle(XTextDocument doc, String name) throws WrappedTargetException {
        return UnoStyle.getInternalNameOfStyle(doc, PARAGRAPH_STYLES, name);
    }

    public static Optional<String> getInternalNameOfCharacterStyle(XTextDocument doc, String name) throws WrappedTargetException {
        return UnoStyle.getInternalNameOfStyle(doc, CHARACTER_STYLES, name);
    }
}

