/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class OOVoidResult<E> {
    private final Optional<E> error;

    private OOVoidResult(Optional<E> error) {
        this.error = error;
    }

    public static <E> OOVoidResult<E> ok() {
        return new OOVoidResult(Optional.empty());
    }

    public static <E> OOVoidResult<E> error(E error) {
        return new OOVoidResult<E>(Optional.of(error));
    }

    public boolean isError() {
        return this.error.isPresent();
    }

    public boolean isOK() {
        return !this.isError();
    }

    public E getError() {
        return this.error.get();
    }

    public OOVoidResult<E> ifError(Consumer<E> fun) {
        if (this.isError()) {
            fun.accept(this.getError());
        }
        return this;
    }

    public <F> OOVoidResult<F> mapError(Function<E, F> fun) {
        if (this.isError()) {
            return OOVoidResult.error(fun.apply(this.getError()));
        }
        return OOVoidResult.ok();
    }
}

