/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.jabref.model.util.DirectoryMonitor;

public class DirectoryMonitorManager {
    private final DirectoryMonitor directoryMonitor;
    private final List<FileAlterationObserver> observers = new ArrayList<FileAlterationObserver>();

    public DirectoryMonitorManager(DirectoryMonitor directoryMonitor) {
        this.directoryMonitor = directoryMonitor;
    }

    public void addObserver(FileAlterationObserver observer, FileAlterationListener listener) {
        this.directoryMonitor.addObserver(observer, listener);
        this.observers.add(observer);
    }

    public void removeObserver(FileAlterationObserver observer) {
        this.directoryMonitor.removeObserver(observer);
        this.observers.remove(observer);
    }

    public void unregister() {
        this.observers.forEach(this.directoryMonitor::removeObserver);
        this.observers.clear();
    }
}

