/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.util;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MultiKeyMap<K1 extends Enum<K1>, K2, V> {
    private final EnumMap<K1, Map<K2, V>> map;

    public MultiKeyMap(Class<K1> keyType) {
        this.map = new EnumMap(keyType);
    }

    public Optional<V> get(K1 key1, K2 key2) {
        Map<K2, V> metaValue = this.map.get(key1);
        if (metaValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metaValue.get(key2));
    }

    public void put(K1 key1, K2 key2, V value) {
        Map<K2, V> metaValue = this.map.get(key1);
        if (metaValue == null) {
            HashMap<K2, V> newMetaValue = new HashMap<K2, V>();
            newMetaValue.put(key2, value);
            this.map.put(key1, newMetaValue);
        } else {
            metaValue.put(key2, value);
        }
    }

    public void remove(K1 key1) {
        this.map.remove(key1);
    }
}

