/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.actions;

import com.cburch.draw.Strings;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.undo.UndoAction;
import java.util.Collection;
import java.util.Collections;

public abstract class ModelAction
implements UndoAction {
    private final CanvasModel model;

    public ModelAction(CanvasModel model) {
        this.model = model;
    }

    static String getShapesName(Collection<CanvasObject> coll) {
        if (coll.size() != 1) {
            return Strings.S.get("shapeMultiple");
        }
        CanvasObject shape = coll.iterator().next();
        return shape.getDisplayName();
    }

    @Override
    public final void doIt() {
        this.doSub(this.model);
    }

    abstract void doSub(CanvasModel var1);

    public CanvasModel getModel() {
        return this.model;
    }

    @Override
    public abstract String getName();

    public Collection<CanvasObject> getObjects() {
        return Collections.emptySet();
    }

    @Override
    public final void undo() {
        this.undoSub(this.model);
    }

    abstract void undoSub(CanvasModel var1);
}

