/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.actions;

import com.cburch.draw.Strings;
import com.cburch.draw.actions.ModelAction;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import java.util.Collection;
import java.util.Collections;

public class ModelMoveHandleAction
extends ModelAction {
    private final HandleGesture gesture;
    private Handle newHandle;

    public ModelMoveHandleAction(CanvasModel model, HandleGesture gesture) {
        super(model);
        this.gesture = gesture;
    }

    @Override
    void doSub(CanvasModel model) {
        this.newHandle = model.moveHandle(this.gesture);
    }

    @Override
    public String getName() {
        return Strings.S.get("actionMoveHandle");
    }

    public Handle getNewHandle() {
        return this.newHandle;
    }

    @Override
    public Collection<CanvasObject> getObjects() {
        return Collections.singleton(this.gesture.getHandle().getObject());
    }

    @Override
    void undoSub(CanvasModel model) {
        Handle oldHandle = this.gesture.getHandle();
        int dx = oldHandle.getX() - this.newHandle.getX();
        int dy = oldHandle.getY() - this.newHandle.getY();
        HandleGesture reverse = new HandleGesture(this.newHandle, dx, dy, 0);
        model.moveHandle(reverse);
    }
}

