/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.canvas;

import com.cburch.draw.canvas.ActionDispatcher;
import com.cburch.draw.canvas.CanvasListener;
import com.cburch.draw.canvas.CanvasTool;
import com.cburch.draw.canvas.Selection;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.undo.UndoAction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class Canvas
extends JComponent {
    public static final String TOOL_PROPERTY = "tool";
    public static final String MODEL_PROPERTY = "model";
    private static final long serialVersionUID = 1L;
    private final CanvasListener listener = new CanvasListener(this);
    private CanvasModel model = null;
    private ActionDispatcher dispatcher;
    private Selection selection = new Selection();
    private Location tooltipLocation;
    private String tooltipName;

    public Canvas() {
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addKeyListener(this.listener);
        this.setPreferredSize(new Dimension(200, 200));
    }

    public void doAction(UndoAction action) {
        this.dispatcher.doAction(action);
    }

    public CanvasModel getModel() {
        return this.model;
    }

    public Selection getSelection() {
        return this.selection;
    }

    protected void setSelection(Selection value) {
        this.selection = value;
        this.repaint();
    }

    public CanvasTool getTool() {
        return this.listener.getTool();
    }

    public void setTool(CanvasTool value) {
        CanvasTool oldValue = this.listener.getTool();
        if (value != oldValue) {
            this.listener.setTool(value);
            this.firePropertyChange(TOOL_PROPERTY, oldValue, value);
        }
    }

    public double getZoomFactor() {
        return 1.0;
    }

    protected void paintBackground(Graphics g) {
        if (AppPreferences.AntiAliassing.getBoolean()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintBackground(g);
        this.paintForeground(g);
        this.paintTooltip(g);
    }

    public void setTooltip(Location loc, String name) {
        this.tooltipLocation = loc;
        this.tooltipName = name;
    }

    private void paintTooltip(Graphics g) {
        if (this.tooltipLocation == null || this.tooltipName == null) {
            return;
        }
        g.setColor(Color.YELLOW);
        int x = (int)((double)this.tooltipLocation.getX() * this.getZoomFactor());
        int y = (int)((double)this.tooltipLocation.getY() * this.getZoomFactor());
        int width = (int)((double)(this.tooltipName.length() * 8) * this.getZoomFactor());
        int height = (int)(12.0 * this.getZoomFactor());
        g.fillRect(x, y, width, height);
        g.setColor(Color.BLUE);
        g.setFont(DrawAttr.DEFAULT_FIXED_PICH_FONT.deriveFont((float)(this.getZoomFactor() * 12.0)));
        GraphicsUtil.drawText(g, this.tooltipName, x + 2, y, -1, -1);
    }

    protected void paintForeground(Graphics g) {
        Graphics dup;
        CanvasModel canvasModel = this.model;
        CanvasTool tool = this.listener.getTool();
        if (canvasModel != null) {
            dup = g.create();
            canvasModel.paint(g, this.selection);
            dup.dispose();
        }
        if (tool != null) {
            dup = g.create();
            tool.draw(this, dup);
            dup.dispose();
        }
    }

    public void repaintCanvasCoords(int x, int y, int width, int height) {
        this.repaint(x, y, width, height);
    }

    public void setModel(CanvasModel value, ActionDispatcher dispatcher) {
        CanvasModel oldValue = this.model;
        if (oldValue != null && !oldValue.equals(value)) {
            oldValue.removeCanvasModelListener(this.listener);
        }
        this.model = value;
        this.dispatcher = dispatcher;
        if (value != null) {
            value.addCanvasModelListener(this.listener);
        }
        this.selection.clearSelected();
        this.repaint();
        this.firePropertyChange(MODEL_PROPERTY, oldValue, value);
    }

    protected JPopupMenu showPopupMenu(MouseEvent e, CanvasObject clicked) {
        return null;
    }

    public int snapX(int x) {
        return x;
    }

    public int snapY(int y) {
        return y;
    }

    public void toolGestureComplete(CanvasTool tool, CanvasObject created) {
    }
}

