/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.toolbar;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.draw.toolbar.Toolbar;
import com.cburch.draw.toolbar.ToolbarClickableItem;
import com.cburch.draw.toolbar.ToolbarItem;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

class ToolbarButton
extends JComponent
implements BaseMouseListenerContract {
    private static final long serialVersionUID = 1L;
    private static final int BORDER = 2;
    private final Toolbar toolbar;
    private final ToolbarItem item;

    ToolbarButton(Toolbar toolbar, ToolbarItem item) {
        this.toolbar = toolbar;
        this.item = item;
        this.addMouseListener(this);
        this.setFocusable(true);
        this.setToolTipText("");
    }

    public ToolbarItem getItem() {
        return this.item;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = this.item.getDimension(this.toolbar.getOrientation());
        dim.width += 4;
        dim.height += 4;
        return dim;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return this.item.getToolTip();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.toolbar.setPressed(null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.item != null && (this.item.isSelectable() || this.item instanceof ToolbarClickableItem)) {
            this.toolbar.setPressed(this);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.toolbar.getPressed() == this) {
            ToolbarItem toolbarItem;
            this.toolbar.setPressed(null);
            if (this.item != null && this.item.isSelectable()) {
                this.toolbar.getToolbarModel().itemSelected(this.item);
            } else if (this.item != null && (toolbarItem = this.item) instanceof ToolbarClickableItem) {
                ToolbarClickableItem clickableItem = (ToolbarClickableItem)toolbarItem;
                clickableItem.clicked();
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.toolbar.getPressed() == this) {
            ToolbarItem toolbarItem = this.item;
            if (toolbarItem instanceof ToolbarClickableItem) {
                ToolbarClickableItem clickableItem = (ToolbarClickableItem)toolbarItem;
                Graphics g2 = g.create();
                g2.translate(2, 2);
                clickableItem.paintPressedIcon(this, g2);
                g2.dispose();
                return;
            }
            Dimension dim = this.item.getDimension(this.toolbar.getOrientation());
            Color defaultColor = g.getColor();
            GraphicsUtil.switchToWidth(g, 2);
            g.setColor(Color.GRAY);
            g.fillRect(2, 2, dim.width, dim.height);
            GraphicsUtil.switchToWidth(g, 1);
            g.setColor(defaultColor);
        }
        Graphics g2 = g.create();
        g2.translate(2, 2);
        this.item.paintIcon(this, g2);
        g2.dispose();
        if (this.toolbar.getToolbarModel().isSelected(this.item)) {
            Dimension dim = this.item.getDimension(this.toolbar.getOrientation());
            GraphicsUtil.switchToWidth(g, 2);
            g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
            g.drawRect(2, 2, dim.width, dim.height);
            GraphicsUtil.switchToWidth(g, 1);
        }
    }
}

