/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.tools;

import com.cburch.draw.actions.ModelAddAction;
import com.cburch.draw.actions.ModelEditTextAction;
import com.cburch.draw.actions.ModelRemoveAction;
import com.cburch.draw.canvas.Canvas;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.Text;
import com.cburch.draw.tools.AbstractTool;
import com.cburch.draw.tools.DrawingAttributeSet;
import com.cburch.draw.util.EditableLabelField;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.icons.TextIcon;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class TextTool
extends AbstractTool {
    private static final TextIcon ICON = new TextIcon();
    private final DrawingAttributeSet attrs;
    private final EditableLabelField field;
    private final FieldListener fieldListener;
    private Text curText;
    private Canvas curCanvas;
    private boolean isTextNew;

    public TextTool(DrawingAttributeSet attrs) {
        this.attrs = attrs;
        this.curText = null;
        this.isTextNew = false;
        this.field = new EditableLabelField();
        this.fieldListener = new FieldListener();
        InputMap fieldInput = this.field.getInputMap();
        fieldInput.put(KeyStroke.getKeyStroke(10, 0), "commit");
        fieldInput.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        ActionMap fieldAction = this.field.getActionMap();
        fieldAction.put("commit", this.fieldListener);
        fieldAction.put("cancel", new CancelListener());
    }

    private void cancelText(Canvas canvas) {
        Text cur = this.curText;
        if (cur != null) {
            this.curText = null;
            cur.removeAttributeListener(this.fieldListener);
            canvas.remove(this.field);
            canvas.getSelection().clearSelected();
            canvas.repaint();
        }
    }

    private void commitText(Canvas canvas) {
        Text cur = this.curText;
        if (cur == null) {
            return;
        }
        this.cancelText(canvas);
        boolean isNew = this.isTextNew;
        String newText = this.field.getText();
        if (isNew) {
            if (!newText.equals("")) {
                cur.setText(newText);
                canvas.doAction(new ModelAddAction(canvas.getModel(), cur));
            }
        } else {
            String oldText = cur.getText();
            if (newText.equals("")) {
                canvas.doAction(new ModelRemoveAction(canvas.getModel(), cur));
            } else if (!oldText.equals(newText)) {
                canvas.doAction(new ModelEditTextAction(canvas.getModel(), cur, newText));
            }
        }
    }

    @Override
    public void draw(Canvas canvas, Graphics gfx) {
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return DrawAttr.ATTRS_TEXT_TOOL;
    }

    @Override
    public Cursor getCursor(Canvas canvas) {
        return Cursor.getPredefinedCursor(2);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public void mousePressed(Canvas canvas, MouseEvent e) {
        if (this.curText != null) {
            this.commitText(canvas);
        }
        Text clicked = null;
        boolean found = false;
        int mx = e.getX();
        int my = e.getY();
        Location mloc = Location.create(mx, my, false);
        for (CanvasObject o : canvas.getModel().getObjectsFromTop()) {
            if (!(o instanceof Text) || !o.contains(mloc, true)) continue;
            clicked = (Text)o;
            found = true;
            break;
        }
        if (!found) {
            clicked = this.attrs.applyTo(new Text(mx, my, ""));
        }
        this.curText = clicked;
        this.curCanvas = canvas;
        this.isTextNew = !found;
        clicked.getLabel().configureTextField(this.field, canvas.getZoomFactor());
        this.field.setText(clicked.getText());
        canvas.add(this.field);
        Point fieldLoc = this.field.getLocation();
        double zoom = canvas.getZoomFactor();
        fieldLoc.x = (int)Math.round((double)mx * zoom - (double)fieldLoc.x);
        fieldLoc.y = (int)Math.round((double)my * zoom - (double)fieldLoc.y);
        int caret = this.field.viewToModel2D(fieldLoc);
        if (caret >= 0) {
            this.field.setCaretPosition(caret);
        }
        this.field.requestFocus();
        canvas.getSelection().setSelected(clicked, true);
        canvas.getSelection().setHidden(Collections.singleton(clicked), true);
        clicked.addAttributeListener(this.fieldListener);
        canvas.repaint();
    }

    @Override
    public void toolDeselected(Canvas canvas) {
        this.commitText(canvas);
    }

    @Override
    public void toolSelected(Canvas canvas) {
        this.cancelText(canvas);
    }

    @Override
    public void zoomFactorChanged(Canvas canvas) {
        Text text = this.curText;
        if (text != null) {
            text.getLabel().configureTextField(this.field, canvas.getZoomFactor());
        }
    }

    private class FieldListener
    extends AbstractAction
    implements AttributeListener {
        private static final long serialVersionUID = 1L;

        private FieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextTool.this.commitText(TextTool.this.curCanvas);
        }

        @Override
        public void attributeListChanged(AttributeEvent e) {
            Text cur = TextTool.this.curText;
            if (cur != null) {
                double zoom = TextTool.this.curCanvas.getZoomFactor();
                cur.getLabel().configureTextField(TextTool.this.field, zoom);
                TextTool.this.curCanvas.repaint();
            }
        }

        @Override
        public void attributeValueChanged(AttributeEvent e) {
            this.attributeListChanged(e);
        }
    }

    private class CancelListener
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextTool.this.cancelText(TextTool.this.curCanvas);
        }
    }
}

