/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.draw.util;

import com.cburch.draw.model.CanvasObject;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MatchingSet<E extends CanvasObject>
extends AbstractSet<E> {
    private final Set<Member<E>> set;

    public MatchingSet() {
        this.set = new HashSet<Member<E>>();
    }

    public MatchingSet(Collection<E> initialContents) {
        this.set = new HashSet<Member<E>>(initialContents.size());
        for (CanvasObject value : initialContents) {
            this.set.add(new Member<CanvasObject>(value));
        }
    }

    @Override
    public boolean add(E value) {
        return this.set.add(new Member<E>(value));
    }

    @Override
    public boolean contains(Object value) {
        CanvasObject eValue = (CanvasObject)value;
        return this.set.contains(new Member<CanvasObject>(eValue));
    }

    @Override
    public Iterator<E> iterator() {
        return new MatchIterator<E>(this.set.iterator());
    }

    @Override
    public boolean remove(Object value) {
        CanvasObject eValue = (CanvasObject)value;
        return this.set.remove(new Member<CanvasObject>(eValue));
    }

    @Override
    public int size() {
        return this.set.size();
    }

    private static class Member<E extends CanvasObject> {
        final E value;

        public Member(E value) {
            this.value = value;
        }

        public boolean equals(Object other) {
            Member that = (Member)other;
            return this.value.matches((CanvasObject)that.value);
        }

        public int hashCode() {
            return this.value.matchesHashCode();
        }
    }

    private static class MatchIterator<E extends CanvasObject>
    implements Iterator<E> {
        private final Iterator<Member<E>> it;

        MatchIterator(Iterator<Member<E>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public E next() {
            return this.it.next().value;
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }
}

