/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.data;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.data.CsvParameter;
import com.cburch.logisim.analyze.gui.VariableTab;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.analyze.model.VariableList;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.util.SyntaxChecker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.swing.JFrame;

public class CsvInterpretor {
    private ArrayList<List<String>> content = new ArrayList();
    final JFrame parent;
    private final VariableList inputs = new VariableList(20);
    private final VariableList outputs = new VariableList(256);
    private final String fileName;

    public CsvInterpretor(File file, CsvParameter param, JFrame parent) {
        this.fileName = file.getName();
        this.parent = parent;
        this.readFile(file, param);
        if (this.content.isEmpty()) {
            return;
        }
        if (!this.getInputsOutputs() || !this.checkEntries()) {
            this.content = new ArrayList();
        }
    }

    public void getTruthTable(AnalyzerModel model) throws IOException {
        if (this.content.size() <= 1) {
            return;
        }
        ArrayList<Entry[]> rows = new ArrayList<Entry[]>();
        int nrOfEntries = this.inputs.bits.size() + this.outputs.bits.size();
        for (int row = 1; row < this.content.size(); ++row) {
            ArrayList<Entry> entryRow = new ArrayList<Entry>();
            List<String> line = this.content.get(row);
            for (int col = 0; col < line.size(); ++col) {
                if (col == this.inputs.bits.size()) continue;
                String entry = line.get(col);
                if ("-xX".indexOf(entry.charAt(0)) >= 0) {
                    entryRow.add(Entry.DONT_CARE);
                    continue;
                }
                if (entry.charAt(0) == '0') {
                    entryRow.add(Entry.ZERO);
                    continue;
                }
                if (entry.charAt(0) == '1') {
                    entryRow.add(Entry.ONE);
                    continue;
                }
                throw new IOException("Invalid entry value");
            }
            if (entryRow.size() != nrOfEntries) {
                throw new IOException("Invalid nr of entries");
            }
            rows.add(entryRow.toArray(new Entry[nrOfEntries]));
        }
        try {
            model.setVariables(this.inputs.vars, this.outputs.vars);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
        TruthTable table = model.getTruthTable();
        try {
            table.setVisibleRows(rows, false);
        }
        catch (IllegalArgumentException e) {
            int confirm = OptionPane.showConfirmDialog(this.parent, new String[]{e.getMessage(), Strings.S.get("tableParseErrorMessage")}, Strings.S.get("openButton"), 0);
            if (confirm != 0) {
                return;
            }
            try {
                table.setVisibleRows(rows, true);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    private boolean checkEntries() {
        if (this.content.size() == 1) {
            OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvNoEntries", this.fileName), Strings.S.get("openButton"), 0);
            return false;
        }
        for (int row = 1; row < this.content.size(); ++row) {
            List<String> line = this.content.get(row);
            for (int col = 0; col < line.size(); ++col) {
                String entry;
                if (col == this.inputs.bits.size() || (entry = line.get(col)) != null && entry.length() == 1 && "01-xX".indexOf(entry.charAt(0)) >= 0) continue;
                OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvInvalidEntry", row + 1, this.fileName, entry, col + 1), Strings.S.get("openButton"), 0);
                return false;
            }
        }
        return true;
    }

    private boolean isDuplicate(String name) {
        for (Var v : this.inputs.vars) {
            if (!v.name.equalsIgnoreCase(name)) continue;
            OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvDuplicatedVar", 1, this.fileName, name), Strings.S.get("openButton"), 0);
            return true;
        }
        for (Var v : this.outputs.vars) {
            if (!v.name.equalsIgnoreCase(name)) continue;
            OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvDuplicatedVar", 1, this.fileName, name), Strings.S.get("openButton"), 0);
            return true;
        }
        return false;
    }

    private boolean isCorrectName(String name) {
        if (!SyntaxChecker.isVariableNameAcceptable(name, false)) {
            OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvIncorrectVarName", 1, this.fileName, name), Strings.S.get("openButton"), 0);
            return false;
        }
        return true;
    }

    private boolean getInputsOutputs() {
        List<String> header = this.content.get(0);
        int nrOfEntries = header.size();
        for (int line = 1; line < this.content.size(); ++line) {
            if (this.content.get(line).size() == nrOfEntries) continue;
            OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvIncorrectLine", line + 1, this.fileName, this.content.get(line).size(), nrOfEntries), Strings.S.get("openButton"), 0);
            return false;
        }
        HashMap bitspresent = new HashMap();
        boolean processingInputs = true;
        boolean inOuSepDetected = false;
        for (int idx = 0; idx < nrOfEntries; ++idx) {
            String name;
            String field = header.get(idx);
            if (field == null) {
                OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvIncorrectEmpty", 1, this.fileName, idx), Strings.S.get("openButton"), 0);
                return false;
            }
            if (field.contains("|")) {
                processingInputs = false;
                inOuSepDetected = true;
                continue;
            }
            if (field.contains(":")) {
                int pos = field.indexOf(":");
                name = field.substring(0, pos);
                if (!this.isCorrectName(name)) {
                    return false;
                }
                String index = field.substring(pos + 1);
                for (char kar : index.toCharArray()) {
                    if ("0123456789".indexOf(kar) >= 0) continue;
                    OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvIncorrectVarName", 1, this.fileName, field), Strings.S.get("openButton"), 0);
                    return false;
                }
                int bitIndex = Integer.parseInt(index);
                if (bitspresent.containsKey(name.toLowerCase())) {
                    ArrayList sels = (ArrayList)bitspresent.get(name.toLowerCase());
                    if (bitIndex >= sels.size() || !((Boolean)sels.get(bitIndex + 1)).booleanValue()) {
                        OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvIncorrectBitOrder", 1, this.fileName, name), Strings.S.get("openButton"), 0);
                        return false;
                    }
                    if (((Boolean)sels.get(bitIndex)).booleanValue()) {
                        OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvDuplicatedBit", 1, this.fileName, bitIndex, name), Strings.S.get("openButton"), 0);
                        return false;
                    }
                    sels.set(bitIndex, true);
                    continue;
                }
                if (this.isDuplicate(name)) {
                    return false;
                }
                Var variable = new Var(name, bitIndex + 1);
                ArrayList<Boolean> sels = new ArrayList<Boolean>();
                for (int a = 0; a < bitIndex; ++a) {
                    sels.add(false);
                }
                sels.add(true);
                bitspresent.put(name.toLowerCase(), sels);
                if (processingInputs) {
                    this.inputs.add(variable);
                    continue;
                }
                this.outputs.add(variable);
                continue;
            }
            if (field.contains("[")) {
                int pos = field.indexOf(91);
                name = field.substring(0, pos);
                if (!this.isCorrectName(name)) {
                    return false;
                }
                if (this.isDuplicate(name)) {
                    return false;
                }
                int nrOfBits = VariableTab.checkindex(field.substring(pos));
                if (nrOfBits <= 0) {
                    OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvIncorrectVarName", 1, this.fileName, field), Strings.S.get("openButton"), 0);
                    return false;
                }
                if (idx + nrOfBits > nrOfEntries) {
                    OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvNotEnoughEmpty", 1, this.fileName, field), Strings.S.get("openButton"), 0);
                    return false;
                }
                for (int x = 1; x < nrOfBits; ++x) {
                    if (header.get(idx + x) == null) continue;
                    OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvNotEnoughEmpty", 1, this.fileName, field), Strings.S.get("openButton"), 0);
                    return false;
                }
                idx += nrOfBits - 1;
                Var variable = new Var(name, nrOfBits);
                if (processingInputs) {
                    this.inputs.add(variable);
                    continue;
                }
                this.outputs.add(variable);
                continue;
            }
            if (!this.isCorrectName(field) || this.isDuplicate(field)) {
                return false;
            }
            Var variable = new Var(field, 1);
            if (processingInputs) {
                this.inputs.add(variable);
                continue;
            }
            this.outputs.add(variable);
        }
        if (!inOuSepDetected) {
            OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvNoSepFound", 1, this.fileName), Strings.S.get("openButton"), 0);
            return false;
        }
        if (this.inputs.bits.isEmpty()) {
            OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvNoInputsFound", 1, this.fileName), Strings.S.get("openButton"), 0);
            return false;
        }
        for (String key : bitspresent.keySet()) {
            ArrayList bit = (ArrayList)bitspresent.get(key);
            for (int x = 0; x < bit.size(); ++x) {
                if (((Boolean)bit.get(x)).booleanValue()) continue;
                OptionPane.showMessageDialog(this.parent, Strings.S.get("CsvBitNotSpecified", 1, this.fileName, x, key), Strings.S.get("openButton"), 0);
                return false;
            }
        }
        return true;
    }

    private void readFile(File file, CsvParameter param) {
        try {
            Scanner scanner = new Scanner(file);
            while (scanner.hasNext()) {
                this.content.add(CsvInterpretor.parseCsvLine(scanner.next(), param.seperator(), param.quote()));
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            OptionPane.showMessageDialog(this.parent, Strings.S.get("cantReadMessage", file.getName()), Strings.S.get("openButton"), 0);
        }
    }

    public static List<String> parseCsvLine(String line, char seperator, char quote) {
        boolean inQuote = false;
        int nrofcontquotes = 0;
        StringBuilder working = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        for (char kar : line.toCharArray()) {
            if (inQuote) {
                if (kar == quote) {
                    ++nrofcontquotes;
                    continue;
                }
                if (nrofcontquotes > 1) {
                    int quotestoprint = nrofcontquotes >> 1;
                    working.append(String.valueOf(quote).repeat(quotestoprint));
                    nrofcontquotes -= quotestoprint << 1;
                }
                if (nrofcontquotes == 1) {
                    inQuote = false;
                    if (kar == seperator) {
                        if (working.length() == 0) {
                            result.add(null);
                        } else {
                            result.add(working.toString());
                            working = new StringBuilder();
                        }
                    } else {
                        working.append(kar);
                    }
                } else {
                    working.append(kar);
                }
                nrofcontquotes = 0;
                continue;
            }
            if (kar == seperator) {
                if (working.length() == 0) {
                    result.add(null);
                    continue;
                }
                result.add(working.toString());
                working = new StringBuilder();
                continue;
            }
            if (kar == quote) {
                inQuote = true;
                continue;
            }
            if (kar == '\r') continue;
            if (kar == '\n') break;
            working.append(kar);
        }
        result.add(working.length() > 0 ? working.toString() : null);
        return result;
    }
}

