/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.gui.AnalyzerMenuListener;
import com.cburch.logisim.analyze.gui.AnalyzerTab;
import com.cburch.logisim.analyze.gui.BuildCircuitButton;
import com.cburch.logisim.analyze.gui.ExportLatexButton;
import com.cburch.logisim.analyze.gui.ExportTableButton;
import com.cburch.logisim.analyze.gui.ExpressionTab;
import com.cburch.logisim.analyze.gui.ImportTableButton;
import com.cburch.logisim.analyze.gui.MinimizeButton;
import com.cburch.logisim.analyze.gui.MinimizedTab;
import com.cburch.logisim.analyze.gui.TableTab;
import com.cburch.logisim.analyze.gui.VariableTab;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.analyze.model.TruthTableEvent;
import com.cburch.logisim.analyze.model.TruthTableListener;
import com.cburch.logisim.gui.generic.LFrame;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Analyzer
extends LFrame.SubWindow {
    private final AnalyzerMenuListener menuListener;
    private static final long serialVersionUID = 1L;
    public static final int IO_TAB = 0;
    public static final int TABLE_TAB = 1;
    public static final int EXPRESSION_TAB = 2;
    public static final int MINIMIZED_TAB = 3;
    private final AnalyzerModel model = new AnalyzerModel();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private final VariableTab ioPanel;
    private final TableTab truthTablePanel;
    private final ExpressionTab expressionPanel;
    private final MinimizedTab minimizedPanel;
    private final BuildCircuitButton buildCircuit;
    private final ImportTableButton importTable;
    private final ExportTableButton exportTable;
    private final ExportLatexButton exportTex;
    private final MinimizeButton minimizeMinterms;
    private final MinimizeButton minimizeMaxterms;

    Analyzer() {
        super((Project)null);
        TableListener tableListener = new TableListener();
        this.model.getTruthTable().addTruthTableListener(tableListener);
        this.menuListener = new AnalyzerMenuListener(this.menubar);
        this.ioPanel = new VariableTab(this.model.getInputs(), this.model.getOutputs(), this.menubar);
        this.truthTablePanel = new TableTab(this.model.getTruthTable());
        this.expressionPanel = new ExpressionTab(this.model, this.menubar);
        this.minimizedPanel = new MinimizedTab(this.model, this.menubar);
        this.importTable = new ImportTableButton(this, this.model);
        this.buildCircuit = new BuildCircuitButton(this, this.model);
        this.buildCircuit.setEnabled(false);
        this.exportTable = new ExportTableButton(this, this.model);
        this.exportTable.setEnabled(false);
        this.exportTex = new ExportLatexButton(this, this.model);
        this.exportTex.setEnabled(false);
        this.minimizeMinterms = new MinimizeButton(this, this.model, 0);
        this.minimizeMinterms.setEnabled(false);
        this.minimizeMaxterms = new MinimizeButton(this, this.model, 1);
        this.minimizeMaxterms.setEnabled(false);
        this.tabbedPane = new JTabbedPane();
        this.addTab(0, this.ioPanel);
        this.addTab(1, this.truthTablePanel);
        this.addTab(2, this.expressionPanel);
        this.addTab(3, this.minimizedPanel);
        this.tabbedPane.setEnabledAt(3, false);
        this.tabbedPane.setEnabledAt(2, false);
        this.tabbedPane.setEnabledAt(1, false);
        Container contents = this.getContentPane();
        JPanel vertStrut = new JPanel(null);
        vertStrut.setPreferredSize(new Dimension(0, AppPreferences.getScaled(300)));
        JPanel horzStrut = new JPanel(null);
        horzStrut.setPreferredSize(new Dimension(AppPreferences.getScaled(450), 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.importTable);
        buttonPanel.add(this.buildCircuit);
        buttonPanel.add(this.minimizeMinterms);
        buttonPanel.add(this.minimizeMaxterms);
        buttonPanel.add(this.exportTable);
        buttonPanel.add(this.exportTex);
        contents.add((Component)vertStrut, "West");
        contents.add((Component)horzStrut, "North");
        contents.add((Component)this.tabbedPane, "Center");
        contents.add((Component)buttonPanel, "South");
        MyLocaleListener myLocaleListener = new MyLocaleListener();
        LocaleManager.addLocaleListener(myLocaleListener);
        myLocaleListener.localeChanged();
        MyChangeListener myChangeListener = new MyChangeListener();
        this.tabbedPane.addChangeListener(myChangeListener);
        this.setSelectedTab(0);
        myChangeListener.stateChanged(null);
    }

    private void addTab(int index, final JComponent comp) {
        if (comp instanceof TableTab || comp instanceof VariableTab || comp instanceof ExpressionTab) {
            this.tabbedPane.insertTab(Strings.S.get("untitled"), null, comp, null, index);
            return;
        }
        final JScrollPane pane = new JScrollPane(comp, 22, 31);
        pane.addComponentListener(new ComponentAdapter(this){

            @Override
            public void componentResized(ComponentEvent event) {
                int width = pane.getViewport().getWidth();
                comp.setSize(new Dimension(width, comp.getHeight()));
            }
        });
        this.tabbedPane.insertTab(Strings.S.get("untitled"), null, pane, null, index);
    }

    public AnalyzerModel getModel() {
        return this.model;
    }

    public void setSelectedTab(int index) {
        Component component = this.tabbedPane.getComponentAt(index);
        if (component instanceof AnalyzerTab) {
            AnalyzerTab found = (AnalyzerTab)component;
            this.model.getOutputExpressions().enableUpdates();
            found.updateTab();
        } else {
            this.model.getOutputExpressions().disableUpdates();
        }
        this.tabbedPane.setSelectedIndex(index);
    }

    private class TableListener
    implements TruthTableListener {
        private TableListener() {
        }

        @Override
        public void rowsChanged(TruthTableEvent event) {
            this.update();
        }

        @Override
        public void cellsChanged(TruthTableEvent event) {
        }

        @Override
        public void structureChanged(TruthTableEvent event) {
            this.update();
        }

        private void update() {
            TruthTable tt = Analyzer.this.model.getTruthTable();
            int nrOfInputs = tt.getInputColumnCount();
            int nrOfOutputs = tt.getOutputColumnCount();
            boolean hasInputsAndOutputs = nrOfInputs > 0 && nrOfOutputs > 0;
            Analyzer.this.buildCircuit.setEnabled(hasInputsAndOutputs);
            Analyzer.this.minimizeMinterms.setEnabled(hasInputsAndOutputs && nrOfInputs > 6);
            Analyzer.this.minimizeMaxterms.setEnabled(hasInputsAndOutputs && nrOfInputs > 6);
            Analyzer.this.exportTable.setEnabled(hasInputsAndOutputs);
            Analyzer.this.exportTex.setEnabled(hasInputsAndOutputs && tt.getRowCount() <= 64);
            Analyzer.this.tabbedPane.setEnabledAt(1, hasInputsAndOutputs);
            Analyzer.this.tabbedPane.setEnabledAt(2, hasInputsAndOutputs && nrOfInputs <= 6);
            Analyzer.this.tabbedPane.setEnabledAt(3, hasInputsAndOutputs && nrOfInputs <= 6);
            Analyzer.this.ioPanel.updateTab();
        }
    }

    private class MyLocaleListener
    implements LocaleListener {
        private MyLocaleListener() {
        }

        @Override
        public void localeChanged() {
            Analyzer.this.setTitle(Strings.S.get("analyzerWindowTitle"));
            Analyzer.this.tabbedPane.setTitleAt(0, Strings.S.get("inputsOutputsTab"));
            Analyzer.this.tabbedPane.setTitleAt(1, Strings.S.get("tableTab"));
            Analyzer.this.tabbedPane.setTitleAt(2, Strings.S.get("expressionTab"));
            Analyzer.this.tabbedPane.setTitleAt(3, Strings.S.get("minimizedTab"));
            Analyzer.this.tabbedPane.setToolTipTextAt(0, Strings.S.get("inputsOutputsTabTip"));
            Analyzer.this.tabbedPane.setToolTipTextAt(1, Strings.S.get("tableTabTip"));
            Analyzer.this.tabbedPane.setToolTipTextAt(2, Strings.S.get("expressionTabTip"));
            Analyzer.this.tabbedPane.setToolTipTextAt(3, Strings.S.get("minimizedTabTip"));
            Analyzer.this.importTable.setText(Strings.S.get("importTableButton"));
            Analyzer.this.buildCircuit.setText(Strings.S.get("buildCircuitButton"));
            Analyzer.this.exportTable.setText(Strings.S.get("exportTableButton"));
            Analyzer.this.exportTex.setText(Strings.S.get("exportLatexButton"));
            Analyzer.this.minimizeMinterms.setText(Strings.S.get("minimizeMintermsButton"));
            Analyzer.this.minimizeMaxterms.setText(Strings.S.get("minimizeMaxtermsButton"));
            Analyzer.this.ioPanel.localeChanged();
            Analyzer.this.truthTablePanel.localeChanged();
            Analyzer.this.expressionPanel.localeChanged();
            Analyzer.this.minimizedPanel.localeChanged();
            Analyzer.this.importTable.localeChanged();
            Analyzer.this.buildCircuit.localeChanged();
            Analyzer.this.exportTable.localeChanged();
            Analyzer.this.exportTex.localeChanged();
        }
    }

    private class MyChangeListener
    implements ChangeListener {
        private MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component selected = Analyzer.this.tabbedPane.getSelectedComponent();
            if (selected instanceof JScrollPane) {
                JScrollPane selScrollPane = (JScrollPane)selected;
                selected = selScrollPane.getViewport().getView();
            }
            if (selected instanceof JPanel) {
                JPanel selPanel = (JPanel)selected;
                selPanel.requestFocus();
            }
            if (selected instanceof AnalyzerTab) {
                AnalyzerTab tab = (AnalyzerTab)selected;
                Analyzer.this.menuListener.setEditHandler(tab.getEditHandler());
                Analyzer.this.menuListener.setPrintHandler(tab.getPrintHandler());
                Analyzer.this.model.getOutputExpressions().enableUpdates();
                tab.updateTab();
            } else {
                Analyzer.this.model.getOutputExpressions().disableUpdates();
            }
        }
    }

    public static abstract class PleaseWait<T>
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private final SwingWorker<T, Void> worker;
        private final Component parentComponent;
        private boolean alreadyFinished = false;

        public abstract T doInBackground();

        public PleaseWait(String title, Component parentComponent) {
            super(null, title, Dialog.ModalityType.APPLICATION_MODAL);
            this.parentComponent = parentComponent;
            this.worker = new SwingWorker<T, Void>(){

                @Override
                protected T doInBackground() {
                    return this.doInBackground();
                }

                @Override
                protected void done() {
                    if (this.isVisible()) {
                        this.dispose();
                    } else {
                        alreadyFinished = true;
                    }
                }
            };
        }

        public T get() {
            this.worker.execute();
            JProgressBar progressBar = new JProgressBar();
            progressBar.setIndeterminate(true);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)progressBar, "Center");
            panel.add((Component)new JLabel(Strings.S.get("analyzePleaseWait")), "First");
            this.add(panel);
            this.setPreferredSize(new Dimension(300, 70));
            this.setDefaultCloseOperation(0);
            this.pack();
            this.setLocationRelativeTo(this.parentComponent);
            try {
                try {
                    return this.worker.get(300L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    if (!this.alreadyFinished) {
                        this.setVisible(true);
                    }
                    return this.worker.get();
                }
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

