/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.gui;

import com.cburch.logisim.analyze.Strings;
import com.cburch.logisim.analyze.file.TruthtableCsvFile;
import com.cburch.logisim.analyze.file.TruthtableTextFile;
import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.util.JFileChoosers;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class ExportTableButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private final JFrame parent;
    private final AnalyzerModel model;
    private File lastFile = null;

    ExportTableButton(JFrame parent, AnalyzerModel model) {
        this.parent = parent;
        this.model = model;
        this.addActionListener(event -> this.doSave());
    }

    void localeChanged() {
        this.setText(Strings.S.get("exportTableButton"));
    }

    void doSave() {
        if (this.lastFile == null) {
            Circuit c = this.model.getCurrentCircuit();
            this.lastFile = c != null ? new File(c.getName() + ".txt") : new File("truthtable.txt");
        }
        JFileChooser chooser = JFileChoosers.createSelected(this.lastFile);
        chooser.setDialogTitle(Strings.S.get("saveButton"));
        chooser.addChoosableFileFilter(TruthtableTextFile.FILE_FILTER);
        chooser.addChoosableFileFilter(TruthtableCsvFile.FILE_FILTER);
        chooser.setFileFilter(TruthtableTextFile.FILE_FILTER);
        int choice = chooser.showSaveDialog(this.parent);
        if (choice == 0) {
            int confirm;
            File file = chooser.getSelectedFile();
            if (file.isDirectory()) {
                OptionPane.showMessageDialog(this.parent, Strings.S.get("notFileMessage", file.getName()), Strings.S.get("saveErrorTitle"), 0);
                return;
            }
            if (file.exists() && !file.canWrite()) {
                OptionPane.showMessageDialog(this.parent, Strings.S.get("cantWriteMessage", file.getName()), Strings.S.get("saveErrorTitle"), 0);
                return;
            }
            if (file.exists() && (confirm = OptionPane.showConfirmDialog(this.parent, Strings.S.get("confirmOverwriteMessage", file.getName()), Strings.S.get("confirmOverwriteTitle"), 0)) != 0) {
                return;
            }
            try {
                String fileName = file.getName();
                int idx = fileName.lastIndexOf(".");
                String ext = fileName.substring(idx + 1);
                if (ext.equals("txt")) {
                    TruthtableTextFile.doSave(file, this.model);
                } else if (ext.equals("csv")) {
                    TruthtableCsvFile.doSave(file, this.model);
                } else {
                    OptionPane.showMessageDialog(this.parent, Strings.S.get("DoNotKnowHowto", fileName), Strings.S.get("openErrorTitle"), 0);
                    return;
                }
                this.lastFile = file;
            }
            catch (IOException e) {
                OptionPane.showMessageDialog(this.parent, e.getMessage(), Strings.S.get("saveErrorTitle"), 0);
            }
        }
    }
}

