/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.analyze.model;

import com.cburch.logisim.analyze.model.AnalyzerModel;
import com.cburch.logisim.analyze.model.Assignments;
import com.cburch.logisim.analyze.model.Entry;
import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.analyze.model.Implicant;
import com.cburch.logisim.analyze.model.OutputExpressionsEvent;
import com.cburch.logisim.analyze.model.OutputExpressionsListener;
import com.cburch.logisim.analyze.model.Parser;
import com.cburch.logisim.analyze.model.TruthTable;
import com.cburch.logisim.analyze.model.TruthTableEvent;
import com.cburch.logisim.analyze.model.TruthTableListener;
import com.cburch.logisim.analyze.model.Var;
import com.cburch.logisim.analyze.model.VariableListEvent;
import com.cburch.logisim.analyze.model.VariableListListener;
import com.cburch.logisim.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTextArea;

public class OutputExpressions {
    private final MyListener myListener = new MyListener();
    private final AnalyzerModel model;
    private final HashMap<String, OutputData> outputData = new HashMap();
    private final ArrayList<OutputExpressionsListener> listeners = new ArrayList();
    private boolean updatingTable = false;
    private boolean allowUpdates = false;

    private static boolean columnsMatch(Entry[] a, Entry[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            boolean bothDefined;
            if (a[i] == b[i]) continue;
            boolean bl = bothDefined = !(a[i] != Entry.ZERO && a[i] != Entry.ONE || b[i] != Entry.ZERO && b[i] != Entry.ONE);
            if (!bothDefined) continue;
            return false;
        }
        return true;
    }

    private static Entry[] computeColumn(TruthTable table, Expression expr) {
        int rows = table.getRowCount();
        int cols = table.getInputColumnCount();
        Object[] values = new Entry[rows];
        if (expr == null) {
            Arrays.fill(values, Entry.DONT_CARE);
        } else {
            Assignments assn = new Assignments();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    assn.put(table.getInputHeader(j), TruthTable.isInputSet(i, j, cols));
                }
                values[i] = expr.evaluate(assn) ? Entry.ONE : Entry.ZERO;
            }
        }
        return values;
    }

    private static boolean implicantsSame(List<Implicant> a, List<Implicant> b) {
        if (a == null) {
            return CollectionUtil.isNullOrEmpty(b);
        }
        if (b == null) {
            return a.isEmpty();
        }
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Implicant> ait = a.iterator();
        for (Implicant bImplicant : b) {
            if (!ait.hasNext()) {
                return false;
            }
            Implicant ai = ait.next();
            if (ai.equals(bImplicant)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllUndefined(Entry[] a) {
        for (Entry entry : a) {
            if (entry != Entry.ZERO && entry != Entry.ONE) continue;
            return false;
        }
        return true;
    }

    public OutputExpressions(AnalyzerModel model) {
        this.model = model;
        model.getInputs().addVariableListListener(this.myListener);
        model.getOutputs().addVariableListListener(this.myListener);
        model.getTruthTable().addTruthTableListener(this.myListener);
    }

    public void forcedOptimize(JTextArea outtextArea, int format) {
        for (String output : this.outputData.keySet()) {
            OutputData data = this.outputData.get(output);
            data.setMinimizedFormat(format);
            data.invalidate(false, false, outtextArea);
        }
    }

    public void addOutputExpressionsListener(OutputExpressionsListener l) {
        this.listeners.add(l);
    }

    private void fireModelChanged(int type) {
        this.fireModelChanged(type, null, null);
    }

    private void fireModelChanged(int type, String variable) {
        this.fireModelChanged(type, variable, null);
    }

    private void fireModelChanged(int type, String variable, Object data) {
        OutputExpressionsEvent event = new OutputExpressionsEvent(this.model, type, variable, data);
        for (OutputExpressionsListener l : this.listeners) {
            l.expressionChanged(event);
        }
    }

    public Expression getExpression(String output) {
        if (output == null) {
            return null;
        }
        try {
            return this.getOutputData(output, true).getExpression();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getExpressionString(String output) {
        if (output == null) {
            return "";
        }
        try {
            return this.getOutputData(output, true).getExpressionString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public Expression getMinimalExpression(String output) {
        if (output == null) {
            return Expressions.constant(0);
        }
        try {
            return this.getOutputData(output, true).getMinimalExpression();
        }
        catch (Exception e) {
            return Expressions.constant(0);
        }
    }

    public List<Implicant> getMinimalImplicants(String output) {
        if (output == null) {
            return Implicant.MINIMAL_LIST;
        }
        try {
            return this.getOutputData(output, true).getMinimalImplicants();
        }
        catch (Exception e) {
            return Implicant.MINIMAL_LIST;
        }
    }

    public int getMinimizedFormat(String output) {
        if (output == null) {
            return 0;
        }
        try {
            return this.getOutputData(output, true).getMinimizedFormat();
        }
        catch (Exception e) {
            return 0;
        }
    }

    private OutputData getOutputData(String output, boolean create) {
        if (output == null) {
            throw new IllegalArgumentException("null output name");
        }
        OutputData ret = this.outputData.get(output);
        if (ret == null && create) {
            if (!this.model.getOutputs().bits.contains(output)) {
                throw new IllegalArgumentException("unrecognized output " + output);
            }
            ret = new OutputData(output);
            this.outputData.put(output, ret);
        }
        return ret;
    }

    private void invalidate(String output) {
        OutputData data = this.getOutputData(output, false);
        if (data != null) {
            if (!this.allowUpdates) {
                this.outputData.remove(output);
            } else {
                data.invalidate(false, false, null);
            }
        }
    }

    public boolean hasExpressions() {
        boolean returnValue = false;
        for (String output : this.outputData.keySet()) {
            OutputData data = this.outputData.get(output);
            returnValue |= data.getMinimalImplicants().size() != 0;
        }
        return returnValue;
    }

    public boolean isExpressionMinimal(String output) {
        OutputData data = this.getOutputData(output, false);
        return data == null || data.isExpressionMinimal();
    }

    public void removeOutputExpressionsListener(OutputExpressionsListener l) {
        this.listeners.remove(l);
    }

    public void setExpression(String output, Expression expr) {
        this.setExpression(output, expr, null);
    }

    public void setExpression(String output, Expression expr, String exprString) {
        if (output == null) {
            return;
        }
        this.getOutputData(output, true).setExpression(expr, exprString);
    }

    public void setMinimizedFormat(String output, int format) {
        int oldFormat = this.getMinimizedFormat(output);
        if (format != oldFormat) {
            this.getOutputData(output, true).setMinimizedFormat(format);
            this.invalidate(output);
        }
    }

    public void enableUpdates() {
        this.allowUpdates = true;
    }

    public void disableUpdates() {
        this.allowUpdates = false;
    }

    public boolean updatesEnabled() {
        return this.allowUpdates;
    }

    private class MyListener
    implements VariableListListener,
    TruthTableListener {
        private MyListener() {
        }

        @Override
        public void rowsChanged(TruthTableEvent event) {
        }

        @Override
        public void cellsChanged(TruthTableEvent event) {
            String output = OutputExpressions.this.model.getOutputs().bits.get(event.getColumn());
            OutputExpressions.this.invalidate(output);
        }

        private void inputsChanged(VariableListEvent event) {
            block7: {
                int type;
                block9: {
                    Var v;
                    block8: {
                        block6: {
                            v = event.getVariable();
                            type = event.getType();
                            if (type != 0 || OutputExpressions.this.outputData.isEmpty()) break block6;
                            OutputExpressions.this.outputData.clear();
                            OutputExpressions.this.fireModelChanged(0);
                            break block7;
                        }
                        if (type != 2) break block8;
                        for (String input : v) {
                            for (String output : OutputExpressions.this.outputData.keySet()) {
                                OutputData data = OutputExpressions.this.getOutputData(output, false);
                                if (data == null) continue;
                                data.removeInput(input);
                            }
                        }
                        break block7;
                    }
                    if (type != 4) break block9;
                    Var newVar = OutputExpressions.this.model.getInputs().vars.get(event.getIndex());
                    for (String output : OutputExpressions.this.outputData.keySet()) {
                        OutputData data;
                        OutputData data2;
                        int b;
                        for (b = 0; b < v.width && b < newVar.width; ++b) {
                            data2 = OutputExpressions.this.getOutputData(output, false);
                            if (data2 == null) continue;
                            data2.replaceInput(v.bitName(b), newVar.bitName(b));
                        }
                        for (b = newVar.width; b < v.width; ++b) {
                            data2 = OutputExpressions.this.getOutputData(output, false);
                            if (data2 == null) continue;
                            data2.removeInput(v.bitName(b));
                        }
                        if (v.width >= newVar.width || (data = OutputExpressions.this.getOutputData(output, false)) == null) continue;
                        data.invalidate(false, false, null);
                    }
                    break block7;
                }
                if (type != 3 && type != 1) break block7;
                for (String output : OutputExpressions.this.outputData.keySet()) {
                    OutputData data = OutputExpressions.this.getOutputData(output, false);
                    if (data == null) continue;
                    data.invalidate(false, false, null);
                }
            }
        }

        @Override
        public void listChanged(VariableListEvent event) {
            if (event.getSource() == OutputExpressions.this.model.getInputs()) {
                this.inputsChanged(event);
            } else {
                this.outputsChanged(event);
            }
        }

        private void outputsChanged(VariableListEvent event) {
            block4: {
                int b;
                int type;
                block5: {
                    block3: {
                        type = event.getType();
                        if (type != 0 || OutputExpressions.this.outputData.isEmpty()) break block3;
                        OutputExpressions.this.outputData.clear();
                        OutputExpressions.this.fireModelChanged(0);
                        break block4;
                    }
                    if (type != 2) break block5;
                    for (String bit : event.getVariable()) {
                        OutputExpressions.this.outputData.remove(bit);
                    }
                    break block4;
                }
                if (type != 4) break block4;
                Var oldVar = event.getVariable();
                Var newVar = OutputExpressions.this.model.getOutputs().vars.get(event.getIndex());
                for (b = 0; b < oldVar.width && b < newVar.width; ++b) {
                    String oldName = oldVar.bitName(b);
                    String newName = newVar.bitName(b);
                    if (!OutputExpressions.this.outputData.containsKey(oldName)) continue;
                    OutputData toMove = OutputExpressions.this.outputData.remove(oldName);
                    toMove.output = newName;
                    OutputExpressions.this.outputData.put(newName, toMove);
                }
                for (b = newVar.width; b < oldVar.width; ++b) {
                    OutputExpressions.this.outputData.remove(oldVar.bitName(b));
                }
            }
        }

        @Override
        public void structureChanged(TruthTableEvent event) {
        }
    }

    private class OutputData {
        String output;
        int format;
        Expression expr = null;
        String exprString = null;
        List<Implicant> minimalImplicants = null;
        Expression minimalExpr = null;
        private boolean invalidating = false;

        OutputData(String output) {
            this.output = output;
            this.invalidate(true, false, null);
        }

        Expression getExpression() {
            return this.expr;
        }

        String getExpressionString() {
            if (this.exprString == null) {
                if (this.expr == null) {
                    this.invalidate(false, false, null);
                }
                this.exprString = this.expr == null ? "" : this.expr.toString();
            }
            return this.exprString;
        }

        Expression getMinimalExpression() {
            if (this.minimalExpr == null) {
                this.invalidate(false, false, null);
            }
            return this.minimalExpr;
        }

        List<Implicant> getMinimalImplicants() {
            return this.minimalImplicants;
        }

        int getMinimizedFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invalidate(boolean initializing, boolean formatChanged, JTextArea outputArea) {
            if (this.invalidating) {
                return;
            }
            this.invalidating = true;
            try {
                boolean minChanged;
                List<Implicant> oldImplicants = this.minimalImplicants;
                Expression oldMinExpr = this.minimalExpr;
                this.minimalImplicants = Implicant.computeMinimal(this.format, OutputExpressions.this.model, this.output, outputArea);
                this.minimalExpr = Implicant.toExpression(this.format, OutputExpressions.this.model, this.minimalImplicants);
                boolean bl = minChanged = !OutputExpressions.implicantsSame(oldImplicants, this.minimalImplicants);
                if (!OutputExpressions.this.updatingTable) {
                    TruthTable table = OutputExpressions.this.model.getTruthTable();
                    Entry[] outputColumn = OutputExpressions.computeColumn(OutputExpressions.this.model.getTruthTable(), this.expr);
                    int outputIndex = OutputExpressions.this.model.getOutputs().bits.indexOf(this.output);
                    Entry[] currentColumn = table.getOutputColumn(outputIndex);
                    if (!OutputExpressions.columnsMatch(currentColumn, outputColumn) || OutputExpressions.isAllUndefined(outputColumn) || formatChanged) {
                        boolean exprChanged = this.expr != oldMinExpr || minChanged;
                        this.expr = this.minimalExpr;
                        if (exprChanged) {
                            this.exprString = null;
                            if (!initializing) {
                                OutputExpressions.this.fireModelChanged(1, this.output);
                            }
                        }
                    }
                }
                if (!initializing && minChanged) {
                    OutputExpressions.this.fireModelChanged(2, this.output);
                }
            }
            finally {
                this.invalidating = false;
            }
        }

        boolean isExpressionMinimal() {
            return this.expr == this.minimalExpr;
        }

        private void removeInput(String input) {
            Expression oldMinExpr = this.minimalExpr;
            this.minimalImplicants = null;
            this.minimalExpr = null;
            if (this.exprString != null) {
                this.exprString = null;
            }
            if (this.expr != null) {
                Expression newExpr;
                Expression oldExpr = this.expr;
                if (oldExpr == oldMinExpr) {
                    this.expr = newExpr = this.getMinimalExpression();
                } else {
                    newExpr = this.expr.removeVariable(input);
                }
                if (newExpr == null || !newExpr.equals(oldExpr)) {
                    this.expr = newExpr;
                    OutputExpressions.this.fireModelChanged(1, this.output, this.expr);
                }
            }
            OutputExpressions.this.fireModelChanged(2, this.output, this.minimalExpr);
        }

        private void replaceInput(String input, String newName) {
            this.minimalExpr = null;
            if (this.exprString != null) {
                this.exprString = Parser.replaceVariable(this.exprString, input, newName);
            }
            if (this.expr != null) {
                Expression newExpr = this.expr.replaceVariable(input, newName);
                if (!newExpr.equals(this.expr)) {
                    this.expr = newExpr;
                    OutputExpressions.this.fireModelChanged(1, this.output);
                }
            } else {
                OutputExpressions.this.fireModelChanged(1, this.output);
            }
            OutputExpressions.this.fireModelChanged(2, this.output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setExpression(Expression newExpr, String newExprString) {
            this.expr = newExpr;
            this.exprString = newExprString;
            if (this.expr != this.minimalExpr) {
                Entry[] values = OutputExpressions.computeColumn(OutputExpressions.this.model.getTruthTable(), this.expr);
                int outputColumn = OutputExpressions.this.model.getOutputs().bits.indexOf(this.output);
                OutputExpressions.this.updatingTable = true;
                try {
                    OutputExpressions.this.model.getTruthTable().setOutputColumn(outputColumn, values);
                }
                finally {
                    OutputExpressions.this.updatingTable = false;
                }
            }
            OutputExpressions.this.fireModelChanged(1, this.output, this.getExpression());
        }

        void setMinimizedFormat(int value) {
            if (this.format != value) {
                this.format = value;
                this.invalidate(false, true, null);
            }
        }
    }
}

