/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitLocker;
import com.cburch.logisim.circuit.CircuitMapInfo;
import com.cburch.logisim.circuit.CircuitMutator;
import com.cburch.logisim.circuit.CircuitMutatorImpl;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.CircuitTransaction;
import com.cburch.logisim.circuit.CircuitWires;
import com.cburch.logisim.circuit.Propagator;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.WidthIncompatibilityData;
import com.cburch.logisim.circuit.Wire;
import com.cburch.logisim.circuit.WireSet;
import com.cburch.logisim.circuit.appear.CircuitAppearance;
import com.cburch.logisim.circuit.appear.DynamicElementProvider;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentEvent;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.comp.ComponentListener;
import com.cburch.logisim.comp.EndData;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.FailException;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.TestException;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.fpga.data.MappableResourcesContainer;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.gui.Reporter;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.soc.data.SocSimulationManager;
import com.cburch.logisim.std.memory.Rom;
import com.cburch.logisim.std.wiring.Clock;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.std.wiring.Tunnel;
import com.cburch.logisim.tools.LibraryTools;
import com.cburch.logisim.tools.SetAttributeAction;
import com.cburch.logisim.util.AutoLabel;
import com.cburch.logisim.util.CollectionUtil;
import com.cburch.logisim.util.EventSourceWeakSupport;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.WeakHashMap;

public class Circuit {
    private static final int maxTimeoutTestBenchSec = 60000;
    private final MyComponentListener myComponentListener = new MyComponentListener();
    private final CircuitAppearance appearance;
    private final AttributeSet staticAttrs;
    private final SubcircuitFactory subcircuitFactory;
    private final EventSourceWeakSupport<CircuitListener> listeners = new EventSourceWeakSupport();
    private LinkedHashSet<Component> comps = new LinkedHashSet();
    CircuitWires wires = new CircuitWires();
    private final List<Component> clocks = new ArrayList<Component>();
    private final CircuitLocker locker;
    private final WeakHashMap<Component, Circuit> circuitsUsingThis;
    private final Netlist myNetList;
    private final Map<String, MappableResourcesContainer> myMappableResources;
    private final Map<String, Map<String, CircuitMapInfo>> loadedMaps;
    private boolean isAnnotated;
    private Project proj;
    private final SocSimulationManager socSim = new SocSimulationManager();
    private final LogisimFile logiFile;

    public static boolean isCorrectLabel(String circuitName, String name, Set<Component> components, AttributeSet me, ComponentFactory myFactory, Boolean showDialog) {
        if (myFactory instanceof Tunnel) {
            return true;
        }
        if (circuitName != null && !circuitName.isEmpty() && circuitName.equalsIgnoreCase(name) && myFactory instanceof Pin) {
            if (showDialog.booleanValue()) {
                String msg = Strings.S.get("ComponentLabelEqualCircuitName");
                OptionPane.showMessageDialog(null, "\"" + name + "\" : " + msg);
            }
            return false;
        }
        return !Circuit.isExistingLabel(name, me, components, showDialog) && !Circuit.isComponentName(name, components, showDialog);
    }

    private static boolean isComponentName(String name, Set<Component> comps, Boolean showDialog) {
        if (name.isEmpty()) {
            return false;
        }
        for (Component comp : comps) {
            if (!comp.getFactory().getName().equalsIgnoreCase(name)) continue;
            if (showDialog.booleanValue()) {
                String msg = Strings.S.get("ComponentLabelNameError");
                OptionPane.showMessageDialog(null, "\"" + name + "\" : " + msg);
            }
            return true;
        }
        return false;
    }

    private static boolean isExistingLabel(String name, AttributeSet me, Set<Component> comps, Boolean showDialog) {
        if (name.isEmpty()) {
            return false;
        }
        for (Component comp : comps) {
            String Label;
            if (comp.getAttributeSet().equals(me) || comp.getFactory() instanceof Tunnel || !(Label = comp.getAttributeSet().containsAttribute(StdAttr.LABEL) ? comp.getAttributeSet().getValue(StdAttr.LABEL) : "").equalsIgnoreCase(name)) continue;
            if (showDialog.booleanValue()) {
                String msg = Strings.S.get("UsedLabelNameError");
                OptionPane.showMessageDialog(null, "\"" + name + "\" : " + msg);
            }
            return true;
        }
        return false;
    }

    public static boolean isInput(Component comp) {
        return comp.getEnd(0).getType() != 1;
    }

    public Circuit(String name, LogisimFile file, Project proj) {
        this.staticAttrs = CircuitAttributes.createBaseAttrs(this, name);
        this.appearance = new CircuitAppearance(this);
        this.subcircuitFactory = new SubcircuitFactory(this);
        this.locker = new CircuitLocker();
        this.circuitsUsingThis = new WeakHashMap();
        this.myNetList = new Netlist(this);
        this.myMappableResources = new HashMap<String, MappableResourcesContainer>();
        this.loadedMaps = new HashMap<String, Map<String, CircuitMapInfo>>();
        this.isAnnotated = false;
        this.logiFile = file;
        this.staticAttrs.setValue(CircuitAttributes.NAMED_CIRCUIT_BOX_FIXED_SIZE, AppPreferences.NAMED_CIRCUIT_BOXES_FIXED_SIZE.getBoolean());
        this.proj = proj;
    }

    public void setProject(Project proj) {
        this.proj = proj;
    }

    public Project getProject() {
        return this.proj;
    }

    public SocSimulationManager getSocSimulationManager() {
        return this.socSim;
    }

    public void addCircuitListener(CircuitListener what) {
        this.listeners.add(what);
    }

    public void recalcDefaultShape() {
        if (this.appearance.isDefaultAppearance()) {
            this.appearance.recomputeDefaultAppearance();
        }
    }

    private static String getAnnotationName(Component comp) {
        String componentName = comp.getFactory() instanceof Pin ? (comp.getEnd(0).isOutput() ? (comp.getEnd(0).getWidth().getWidth() > 1 ? "Input_bus" : "Input") : (comp.getEnd(0).getWidth().getWidth() > 1 ? "Output_bus" : "Output")) : comp.getFactory().getHDLName(comp.getAttributeSet());
        return componentName;
    }

    public void annotate(Project proj, boolean clearExistingLabels, boolean insideLibrary) {
        if (this.proj == null) {
            this.proj = proj;
        }
        this.annotate(clearExistingLabels, insideLibrary);
    }

    public void annotate(boolean clearExistingLabels, boolean insideLibrary) {
        String componentName;
        if (this.isAnnotated) {
            Reporter.report.addInfo("Nothing to do!");
            return;
        }
        TreeSet<Location.At> comps = new TreeSet<Location.At>(Location.CompareVertical);
        HashMap<String, AutoLabel> labelers = new HashMap<String, AutoLabel>();
        LinkedHashSet<String> labelNames = new LinkedHashSet<String>();
        LinkedHashSet<String> subCircuits = new LinkedHashSet<String>();
        for (Component comp : this.getNonWires()) {
            Object act;
            String label;
            if (comp.getFactory() instanceof Tunnel) continue;
            AttributeSet attributeSet = comp.getAttributeSet();
            if (attributeSet.containsAttribute(StdAttr.LABEL) && !(label = attributeSet.getValue(StdAttr.LABEL)).isEmpty()) {
                if (labelNames.contains(label.toUpperCase())) {
                    act = new SetAttributeAction(this, Strings.S.getter("changeComponentAttributesAction"));
                    ((SetAttributeAction)act).set(comp, StdAttr.LABEL, "");
                    this.proj.doAction((Action)act);
                    Reporter.report.addSevereWarning("Removed duplicated label " + this.getName() + "/" + label);
                } else {
                    labelNames.add(label.toUpperCase());
                }
            }
            if (comp.getFactory().requiresNonZeroLabel()) {
                if (clearExistingLabels) {
                    Reporter.report.addInfo("Cleared " + this.getName() + "/" + comp.getAttributeSet().getValue(StdAttr.LABEL));
                    SetAttributeAction act2 = new SetAttributeAction(this, Strings.S.getter("changeComponentAttributesAction"));
                    act2.set(comp, StdAttr.LABEL, "");
                    this.proj.doAction(act2);
                }
                if (comp.getAttributeSet().getValue(StdAttr.LABEL).isEmpty()) {
                    comps.add(comp);
                    componentName = Circuit.getAnnotationName(comp);
                    if (!labelers.containsKey(componentName)) {
                        labelers.put(componentName, new AutoLabel(componentName + "_0", this));
                    }
                }
            }
            if (!((act = comp.getFactory()) instanceof SubcircuitFactory)) continue;
            SubcircuitFactory sub = (SubcircuitFactory)act;
            subCircuits.add(sub.getName());
        }
        boolean sizeMightHaveChanged = false;
        for (Component component : comps) {
            componentName = Circuit.getAnnotationName(component);
            if (!labelers.containsKey(componentName) || !((AutoLabel)labelers.get(componentName)).hasNext(this)) {
                Reporter.report.addFatalError("Annotate internal Error: Either there exists duplicate labels or the label syntax is incorrect!\nPlease try annotation on labeled components also\n");
                return;
            }
            String newLabel = ((AutoLabel)labelers.get(componentName)).getNext(this, component.getFactory());
            SetAttributeAction act = new SetAttributeAction(this, Strings.S.getter("changeComponentAttributesAction"));
            act.set(component, StdAttr.LABEL, newLabel);
            this.proj.doAction(act);
            Reporter.report.addInfo("Labeled " + this.getName() + "/" + newLabel);
            if (!(component.getFactory() instanceof Pin)) continue;
            sizeMightHaveChanged = true;
        }
        if (!comps.isEmpty() && insideLibrary) {
            Reporter.report.addSevereWarning("Annotated the circuit \"" + this.getName() + "\" which is inside a library these changes will not be saved!");
        }
        if (sizeMightHaveChanged) {
            Reporter.report.addSevereWarning("Annotated one ore more pins in circuit \"" + this.getName() + "\" this might have changed it's boxsize and might have impacted it's connections in circuits using this one!");
        }
        this.isAnnotated = true;
        for (String string : subCircuits) {
            Circuit circ = LibraryTools.getCircuitFromLibs(this.proj.getLogisimFile(), string.toUpperCase());
            boolean inLibrary = !this.proj.getLogisimFile().getCircuits().contains(circ);
            circ.annotate(this.proj, clearExistingLabels, inLibrary);
        }
    }

    public void clearAnnotationLevel() {
        this.isAnnotated = false;
        this.myNetList.clear();
        for (Component comp : this.getNonWires()) {
            ComponentFactory componentFactory = comp.getFactory();
            if (!(componentFactory instanceof SubcircuitFactory)) continue;
            SubcircuitFactory sub = (SubcircuitFactory)componentFactory;
            sub.getSubcircuit().clearAnnotationLevel();
        }
    }

    public boolean contains(Component c) {
        return this.comps.contains(c) || this.wires.getWires().contains(c);
    }

    public boolean doTestBench(Project project, Instance[] pin, Value[] val) {
        CircuitState state = project.getCircuitState();
        InstanceState[] pinsState = new InstanceState[pin.length];
        Value[] vPins = new Value[pin.length];
        state.reset();
        TimeoutSimulation ts = new TimeoutSimulation();
        Timer timer = new Timer();
        timer.schedule((TimerTask)ts, 60000L);
        do {
            int i = 0;
            project.getSimulator().tick(1);
            Thread.yield();
            for (Instance pinStatus : pin) {
                pinsState[i] = state.getInstanceState(pinStatus);
                vPins[i] = Pin.FACTORY.getValue(pinsState[i]);
                ++i;
            }
            if (!val[0].compatible(vPins[0]) || !vPins[0].equals(Value.TRUE)) continue;
            return val[1].compatible(vPins[1]) && vPins[1].equals(Value.TRUE);
        } while (!ts.isTimeOut());
        return false;
    }

    public void doTestVector(Project project, Instance[] pin, Value[] val) throws TestException {
        CircuitState state = project.getCircuitState();
        state.reset();
        for (int i = 0; i < pin.length; ++i) {
            if (!Pin.FACTORY.isInputPin(pin[i])) continue;
            InstanceState pinState = state.getInstanceState(pin[i]);
            Pin.FACTORY.driveInputPin(pinState, val[i]);
        }
        Propagator prop = state.getPropagator();
        try {
            prop.propagate();
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
        if (prop.isOscillating()) {
            throw new TestException("oscillation detected");
        }
        FailException err = null;
        for (int i = 0; i < pin.length; ++i) {
            Value v;
            InstanceState pinState = state.getInstanceState(pin[i]);
            if (Pin.FACTORY.isInputPin(pin[i]) || val[i].compatible(v = Pin.FACTORY.getValue(pinState))) continue;
            if (err == null) {
                err = new FailException(i, pinState.getAttributeValue(StdAttr.LABEL), val[i], v);
                continue;
            }
            err.add(new FailException(i, pinState.getAttributeValue(StdAttr.LABEL), val[i], v));
        }
        if (err != null) {
            throw err;
        }
    }

    public void draw(ComponentDrawContext context, Collection<Component> hidden) {
        Graphics g = context.getGraphics();
        Graphics gCopy = g.create();
        context.setGraphics(gCopy);
        this.wires.draw(context, hidden);
        if (CollectionUtil.isNullOrEmpty(hidden)) {
            for (Component c : this.comps) {
                Graphics gNew = g.create();
                context.setGraphics(gNew);
                gCopy.dispose();
                gCopy = gNew;
                c.draw(context);
            }
        } else {
            for (Component c : this.comps) {
                if (hidden.contains(c)) continue;
                Graphics gNew = g.create();
                context.setGraphics(gNew);
                gCopy.dispose();
                gCopy = gNew;
                try {
                    c.draw(context);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
        context.setGraphics(g);
        gCopy.dispose();
    }

    private void fireEvent(CircuitEvent event) {
        for (CircuitListener l : this.listeners) {
            l.circuitChanged(event);
        }
    }

    void fireEvent(int action, Object data) {
        this.fireEvent(new CircuitEvent(action, this, data));
    }

    public void displayChanged() {
        this.fireEvent(9, null);
    }

    public Collection<Component> getAllContaining(Location pt) {
        LinkedHashSet<Component> ret = new LinkedHashSet<Component>();
        for (Component comp : this.getComponents()) {
            if (!comp.contains(pt)) continue;
            ret.add(comp);
        }
        return ret;
    }

    public Collection<Component> getAllContaining(Location pt, Graphics g) {
        LinkedHashSet<Component> ret = new LinkedHashSet<Component>();
        for (Component comp : this.getComponents()) {
            if (!comp.contains(pt, g)) continue;
            ret.add(comp);
        }
        return ret;
    }

    public Collection<Component> getAllWithin(Bounds bds) {
        LinkedHashSet<Component> ret = new LinkedHashSet<Component>();
        for (Component comp : this.getComponents()) {
            if (!bds.contains(comp.getBounds())) continue;
            ret.add(comp);
        }
        return ret;
    }

    public Collection<Component> getAllWithin(Bounds bds, Graphics g) {
        LinkedHashSet<Component> ret = new LinkedHashSet<Component>();
        for (Component comp : this.getComponents()) {
            if (!bds.contains(comp.getBounds(g))) continue;
            ret.add(comp);
        }
        return ret;
    }

    public CircuitAppearance getAppearance() {
        return this.appearance;
    }

    public Bounds getBounds() {
        Bounds wireBounds = this.wires.getWireBounds();
        Iterator it = this.comps.iterator();
        if (!it.hasNext()) {
            return wireBounds;
        }
        Component first = (Component)it.next();
        Bounds firstBounds = first.getBounds();
        int xMin = firstBounds.getX();
        int yMin = firstBounds.getY();
        int xMax = xMin + firstBounds.getWidth();
        int yMax = yMin + firstBounds.getHeight();
        while (it.hasNext()) {
            Component c = (Component)it.next();
            Bounds bds = c.getBounds();
            int x0 = bds.getX();
            int x1 = x0 + bds.getWidth();
            int y0 = bds.getY();
            int y1 = y0 + bds.getHeight();
            if (x0 < xMin) {
                xMin = x0;
            }
            if (x1 > xMax) {
                xMax = x1;
            }
            if (y0 < yMin) {
                yMin = y0;
            }
            if (y1 <= yMax) continue;
            yMax = y1;
        }
        Bounds compBounds = Bounds.create(xMin, yMin, xMax - xMin, yMax - yMin);
        return wireBounds.getWidth() == 0 || wireBounds.getHeight() == 0 ? compBounds : compBounds.add(wireBounds);
    }

    public Bounds getBounds(Graphics g) {
        Bounds ret = this.wires.getWireBounds();
        int xMin = ret.getX();
        int yMin = ret.getY();
        int xMax = xMin + ret.getWidth();
        int yMax = yMin + ret.getHeight();
        if (ret == Bounds.EMPTY_BOUNDS) {
            xMin = Integer.MAX_VALUE;
            yMin = Integer.MAX_VALUE;
            xMax = Integer.MIN_VALUE;
            yMax = Integer.MIN_VALUE;
        }
        for (Component comp : this.comps) {
            Bounds bds = comp.getBounds(g);
            if (bds == null || bds == Bounds.EMPTY_BOUNDS) continue;
            int x0 = bds.getX();
            int x1 = x0 + bds.getWidth();
            int y0 = bds.getY();
            int y1 = y0 + bds.getHeight();
            if (x0 < xMin) {
                xMin = x0;
            }
            if (x1 > xMax) {
                xMax = x1;
            }
            if (y0 < yMin) {
                yMin = y0;
            }
            if (y1 <= yMax) continue;
            yMax = y1;
        }
        if (xMin > xMax || yMin > yMax) {
            return Bounds.EMPTY_BOUNDS;
        }
        return Bounds.create(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    public Collection<Circuit> getCircuitsUsingThis() {
        return this.circuitsUsingThis.values();
    }

    public void removeComponent(Component c) {
        this.circuitsUsingThis.remove(c);
    }

    public List<Component> getClocks() {
        return this.clocks;
    }

    public Set<Component> getComponents() {
        return CollectionUtil.createUnmodifiableSetUnion(this.comps, this.wires.getWires());
    }

    public Collection<? extends Component> getComponents(Location loc) {
        return this.wires.points.getComponents(loc);
    }

    public Component getExclusive(Location loc) {
        return this.wires.points.getExclusive(loc);
    }

    public CircuitLocker getLocker() {
        return this.locker;
    }

    public String getName() {
        return this.staticAttrs.getValue(CircuitAttributes.NAME_ATTR);
    }

    public Netlist getNetList() {
        return this.myNetList;
    }

    public void addLoadedMap(String boardName, Map<String, CircuitMapInfo> map) {
        this.loadedMaps.put(boardName, map);
    }

    public Set<String> getBoardMapNamestoSave() {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(this.loadedMaps.keySet());
        ret.addAll(this.myMappableResources.keySet());
        return ret;
    }

    public Map<String, CircuitMapInfo> getMapInfo(String boardName) {
        if (this.myMappableResources.containsKey(boardName)) {
            return this.myMappableResources.get(boardName).getCircuitMap();
        }
        if (this.loadedMaps.containsKey(boardName)) {
            return this.loadedMaps.get(boardName);
        }
        return new HashMap<String, CircuitMapInfo>();
    }

    public void setBoardMap(String boardName, MappableResourcesContainer map) {
        if (this.loadedMaps.containsKey(boardName)) {
            for (String key : this.loadedMaps.get(boardName).keySet()) {
                CircuitMapInfo cmap = this.loadedMaps.get(boardName).get(key);
                map.tryMap(key, cmap);
            }
            this.loadedMaps.remove(boardName);
        }
        this.myMappableResources.put(boardName, map);
    }

    public MappableResourcesContainer getBoardMap(String boardName) {
        if (this.myMappableResources.containsKey(boardName)) {
            return this.myMappableResources.get(boardName);
        }
        return null;
    }

    public Set<String> getMapableBoards() {
        return this.myMappableResources.keySet();
    }

    public Set<Component> getNonWires() {
        return this.comps;
    }

    public Collection<? extends Component> getNonWires(Location loc) {
        return this.wires.points.getNonWires(loc);
    }

    public String getProjName() {
        return this.logiFile == null ? "" : this.logiFile.getName();
    }

    public Collection<? extends Component> getSplitCauses(Location loc) {
        return this.wires.points.getSplitCauses(loc);
    }

    public Set<Location> getAllLocations() {
        return this.wires.points.getAllLocations();
    }

    public AttributeSet getStaticAttributes() {
        return this.staticAttrs;
    }

    public SubcircuitFactory getSubcircuitFactory() {
        return this.subcircuitFactory;
    }

    public BitWidth getWidth(Location p) {
        return this.wires.getWidth(p);
    }

    public Set<WidthIncompatibilityData> getWidthIncompatibilityData() {
        return this.wires.getWidthIncompatibilityData();
    }

    public Set<Wire> getWires() {
        return this.wires.getWires();
    }

    public Collection<Wire> getWires(Location loc) {
        return this.wires.points.getWires(loc);
    }

    public WireSet getWireSet(Wire start) {
        return this.wires.getWireSet(start);
    }

    public boolean hasConflict(Component comp) {
        return this.wires.points.hasConflict(comp) || this.isDoubleMapped(comp);
    }

    private boolean isDoubleMapped(Component comp) {
        Location loc = comp.getLocation();
        Collection<? extends Component> existing = this.wires.points.getNonWires(loc);
        for (Component component : existing) {
            if (!component.getFactory().equals(comp.getFactory())) continue;
            if (comp.getFactory() instanceof Pin) {
                AttributeOption dir2;
                AttributeOption dir1 = comp.getAttributeSet().getValue(Pin.ATTR_TYPE);
                if (!dir1.equals(dir2 = component.getAttributeSet().getValue(Pin.ATTR_TYPE))) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean isConnected(Location loc, Component ignore) {
        for (Component component : this.wires.points.getComponents(loc)) {
            if (component == ignore) continue;
            return true;
        }
        return false;
    }

    void mutatorAdd(Component c) {
        this.locker.checkForWritePermission("add", this);
        this.isAnnotated = false;
        this.myNetList.clear();
        if (c instanceof Wire) {
            Wire wire = (Wire)c;
            if (wire.getEnd0().equals(wire.getEnd1())) {
                return;
            }
            boolean added = this.wires.add(wire);
            if (!added) {
                return;
            }
        } else {
            boolean added = this.comps.add(c);
            if (!added) {
                return;
            }
            this.socSim.registerComponent(c);
            if (c.getAttributeSet().containsAttribute(StdAttr.LABEL) && !(c.getFactory() instanceof Tunnel)) {
                String label;
                HashSet<String> labels = new HashSet<String>();
                for (Component comp : this.comps) {
                    String label2;
                    if (comp.equals(c) || comp.getFactory() instanceof Tunnel || !comp.getAttributeSet().containsAttribute(StdAttr.LABEL) || !StringUtil.isNotEmpty(label2 = comp.getAttributeSet().getValue(StdAttr.LABEL))) continue;
                    labels.add(label2.toUpperCase());
                }
                if (this.getName() != null && !this.getName().isEmpty()) {
                    labels.add(this.getName());
                }
                if (StringUtil.isNotEmpty(label = c.getAttributeSet().getValue(StdAttr.LABEL)) && labels.contains(label.toUpperCase())) {
                    c.getAttributeSet().setValue(StdAttr.LABEL, "");
                }
            }
            this.wires.add(c);
            ComponentFactory factory = c.getFactory();
            if (factory instanceof Clock) {
                this.clocks.add(c);
            } else if (factory instanceof Rom) {
                Rom.closeHexFrame(c);
            } else if (factory instanceof SubcircuitFactory) {
                SubcircuitFactory subFactory;
                SubcircuitFactory subcirc = subFactory = (SubcircuitFactory)factory;
                subcirc.getSubcircuit().circuitsUsingThis.put(c, this);
            } else if (factory instanceof VhdlEntity) {
                VhdlEntity vhdlEntity;
                VhdlEntity vhdl = vhdlEntity = (VhdlEntity)factory;
                vhdl.addCircuitUsing(c, this);
            }
            c.addComponentListener(this.myComponentListener);
        }
        this.removeWrongLabels(c.getFactory().getName());
        this.fireEvent(1, c);
    }

    public void mutatorClear() {
        this.locker.checkForWritePermission("clear", this);
        LinkedHashSet<Component> oldComps = this.comps;
        this.comps = new LinkedHashSet();
        this.wires = new CircuitWires();
        this.clocks.clear();
        this.myNetList.clear();
        this.isAnnotated = false;
        for (Component comp : oldComps) {
            this.socSim.removeComponent(comp);
            ComponentFactory factory = comp.getFactory();
            factory.removeComponent(this, comp, this.proj.getCircuitState(this));
        }
        this.fireEvent(5, oldComps);
    }

    void mutatorRemove(Component c) {
        this.locker.checkForWritePermission("remove", this);
        this.isAnnotated = false;
        this.myNetList.clear();
        if (c instanceof Wire) {
            this.wires.remove(c);
        } else {
            this.wires.remove(c);
            this.comps.remove(c);
            this.socSim.removeComponent(c);
            ComponentFactory factory = c.getFactory();
            factory.removeComponent(this, c, this.proj.getCircuitState(this));
            if (factory instanceof Clock) {
                this.clocks.remove(c);
            } else if (factory instanceof DynamicElementProvider) {
                DynamicElementProvider.removeDynamicElements(this, c);
            }
            c.removeComponentListener(this.myComponentListener);
        }
        this.fireEvent(2, c);
    }

    private void removeWrongLabels(String label) {
        boolean changed = false;
        for (Component comp : this.comps) {
            String compLabel;
            AttributeSet attrs = comp.getAttributeSet();
            if (!attrs.containsAttribute(StdAttr.LABEL) || !label.equalsIgnoreCase(compLabel = attrs.getValue(StdAttr.LABEL))) continue;
            attrs.setValue(StdAttr.LABEL, "");
            changed = true;
        }
        if (changed) {
            OptionPane.showMessageDialog(null, "\"" + label + "\" : " + Strings.S.get("ComponentLabelCollisionError"));
        }
    }

    public void removeCircuitListener(CircuitListener what) {
        this.listeners.remove(what);
    }

    public void setName(String name) {
        this.staticAttrs.setValue(CircuitAttributes.NAME_ATTR, name);
    }

    public String toString() {
        return this.staticAttrs.getValue(CircuitAttributes.NAME_ATTR);
    }

    public double getTickFrequency() {
        return this.staticAttrs.getValue(CircuitAttributes.SIMULATION_FREQUENCY);
    }

    public void setTickFrequency(double value) {
        Double currentTickFrequency = this.staticAttrs.getValue(CircuitAttributes.SIMULATION_FREQUENCY);
        if (value != currentTickFrequency) {
            this.staticAttrs.setValue(CircuitAttributes.SIMULATION_FREQUENCY, value);
            if (this.proj != null && currentTickFrequency > 0.0) {
                this.proj.setForcedDirty();
            }
        }
    }

    public double getDownloadFrequency() {
        return this.staticAttrs.getValue(CircuitAttributes.DOWNLOAD_FREQUENCY);
    }

    public void setDownloadFrequency(double value) {
        if (value != this.staticAttrs.getValue(CircuitAttributes.DOWNLOAD_FREQUENCY)) {
            this.staticAttrs.setValue(CircuitAttributes.DOWNLOAD_FREQUENCY, value);
            if (this.proj != null) {
                this.proj.setForcedDirty();
            }
        }
    }

    public String getDownloadBoard() {
        return this.staticAttrs.getValue(CircuitAttributes.DOWNLOAD_BOARD);
    }

    public void setDownloadBoard(String board) {
        if (!board.equals(this.staticAttrs.getValue(CircuitAttributes.DOWNLOAD_BOARD))) {
            this.staticAttrs.setValue(CircuitAttributes.DOWNLOAD_BOARD, board);
            if (this.proj != null) {
                this.proj.setForcedDirty();
            }
        }
    }

    private class MyComponentListener
    implements ComponentListener {
        private MyComponentListener() {
        }

        @Override
        public void componentInvalidated(ComponentEvent e) {
            Circuit.this.fireEvent(4, e.getSource());
        }

        @Override
        public void endChanged(ComponentEvent e) {
            Circuit.this.locker.checkForWritePermission("ends changed", Circuit.this);
            Circuit.this.isAnnotated = false;
            Circuit.this.myNetList.clear();
            Component comp = e.getSource();
            HashMap<Location, EndData> toRemove = this.toMap(e.getOldData());
            HashMap<Location, EndData> toAdd = this.toMap(e.getData());
            EndChangedTransaction xn = new EndChangedTransaction(comp, toRemove, toAdd);
            Circuit.this.locker.execute(xn);
            Circuit.this.fireEvent(4, comp);
        }

        private HashMap<Location, EndData> toMap(Object val) {
            HashMap<Location, EndData> map = new HashMap<Location, EndData>();
            if (val instanceof List) {
                List valList = (List)val;
                for (EndData end : valList) {
                    if (end == null) continue;
                    map.put(end.getLocation(), end);
                }
            } else if (val instanceof EndData) {
                EndData end = (EndData)val;
                map.put(end.getLocation(), end);
            }
            return map;
        }

        @Override
        public void labelChanged(ComponentEvent e) {
            AttributeEvent attrEvent = (AttributeEvent)e.getData();
            if (attrEvent.getSource() == null || attrEvent.getValue() == null) {
                return;
            }
            String newLabel = (String)attrEvent.getValue();
            String oldLabel = attrEvent.getOldValue() != null ? (String)attrEvent.getOldValue() : "";
            Attribute<?> lattr = attrEvent.getAttribute();
            if (!Circuit.isCorrectLabel(Circuit.this.getName(), newLabel, Circuit.this.comps, attrEvent.getSource(), e.getSource().getFactory(), true)) {
                if (Circuit.isCorrectLabel(Circuit.this.getName(), oldLabel, Circuit.this.comps, attrEvent.getSource(), e.getSource().getFactory(), false)) {
                    attrEvent.getSource().setValue(lattr, oldLabel);
                } else {
                    attrEvent.getSource().setValue(lattr, "");
                }
            }
        }
    }

    public static class TimeoutSimulation
    extends TimerTask {
        private volatile boolean timedOut = false;

        public boolean isTimeOut() {
            return this.timedOut;
        }

        @Override
        public void run() {
            this.timedOut = true;
        }
    }

    private class EndChangedTransaction
    extends CircuitTransaction {
        private final Component comp;
        private final Map<Location, EndData> toRemove;
        private final Map<Location, EndData> toAdd;

        EndChangedTransaction(Component comp, Map<Location, EndData> toRemove, Map<Location, EndData> toAdd) {
            this.comp = comp;
            this.toRemove = toRemove;
            this.toAdd = toAdd;
        }

        @Override
        protected Map<Circuit, Integer> getAccessedCircuits() {
            return Collections.singletonMap(Circuit.this, READ_WRITE);
        }

        @Override
        protected void run(CircuitMutator mutator) {
            for (Location loc : this.toRemove.keySet()) {
                EndData removed = this.toRemove.get(loc);
                EndData replaced = this.toAdd.remove(loc);
                if (replaced == null) {
                    Circuit.this.wires.remove(this.comp, removed);
                    continue;
                }
                if (replaced.equals(removed)) continue;
                Circuit.this.wires.replace(this.comp, removed, replaced);
            }
            for (EndData end : this.toAdd.values()) {
                Circuit.this.wires.add(this.comp, end);
            }
            ((CircuitMutatorImpl)mutator).markModified(Circuit.this);
        }
    }
}

