/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit;

import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.circuit.appear.DynamicElementWithPoker;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.instance.InstanceData;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class SubcircuitPoker
extends InstancePoker {
    private static final Color MAGNIFYING_INTERIOR = new Color(200, 200, 255, 64);
    private static final Color MAGNIFYING_INTERIOR_DOWN = new Color(128, 128, 255, 192);
    private boolean mouseDown;

    @Override
    public Bounds getBounds(InstancePainter painter) {
        Bounds bds = painter.getInstance().getBounds();
        int cx = bds.getX() + bds.getWidth() / 2;
        int cy = bds.getY() + bds.getHeight() / 2;
        return Bounds.create(cx - 5, cy - 5, 15, 15);
    }

    private boolean isWithin(InstanceState state, MouseEvent e) {
        int dy;
        Bounds bds = state.getInstance().getBounds();
        int cx = bds.getX() + bds.getWidth() / 2;
        int cy = bds.getY() + bds.getHeight() / 2;
        int dx = e.getX() - cx;
        return dx * dx + (dy = e.getY() - cy) * dy <= 60;
    }

    @Override
    public void mousePressed(InstanceState state, MouseEvent e) {
        for (CanvasObject c : ((SubcircuitFactory)state.getInstance().getFactory()).getSubcircuit().getAppearance().getObjectsFromTop()) {
            if (!(c instanceof DynamicElementWithPoker)) continue;
            DynamicElementWithPoker dynEl = (DynamicElementWithPoker)c;
            dynEl.mousePressed(state, e);
        }
        if (this.isWithin(state, e)) {
            this.mouseDown = true;
            state.getInstance().fireInvalidated();
        }
    }

    @Override
    public void mouseReleased(InstanceState state, MouseEvent e) {
        for (CanvasObject c : ((SubcircuitFactory)state.getInstance().getFactory()).getSubcircuit().getAppearance().getObjectsFromTop()) {
            if (!(c instanceof DynamicElementWithPoker)) continue;
            DynamicElementWithPoker dynEl = (DynamicElementWithPoker)c;
            dynEl.mouseReleased(state, e);
        }
        if (this.mouseDown) {
            this.mouseDown = false;
            InstanceData sub = state.getData();
            if (e.getClickCount() == 2 && this.isWithin(state, e) && sub instanceof CircuitState) {
                state.getProject().setCircuitState((CircuitState)sub);
            } else {
                state.getInstance().fireInvalidated();
            }
        }
    }

    @Override
    public void paint(InstancePainter painter) {
        if (painter.getDestination() instanceof Canvas && painter.getData() instanceof CircuitState) {
            Bounds bds = painter.getInstance().getBounds();
            int cx = bds.getX() + bds.getWidth() / 2;
            int cy = bds.getY() + bds.getHeight() / 2;
            int tx = cx + 7;
            int ty = cy + 7;
            int[] xp = new int[]{tx - 2, cx + 13, cx + 15, tx + 2};
            int[] yp = new int[]{ty + 2, cy + 15, cy + 13, ty - 2};
            Graphics g = painter.getGraphics();
            if (this.mouseDown) {
                g.setColor(MAGNIFYING_INTERIOR_DOWN);
            } else {
                g.setColor(MAGNIFYING_INTERIOR);
            }
            g.fillOval(cx - 9, cy - 9, 18, 18);
            g.setColor(Color.GRAY);
            g.drawOval(cx - 9, cy - 9, 18, 18);
            g.fillPolygon(xp, yp, xp.length);
        }
    }
}

