/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.draw.model.AbstractCanvasObject;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.model.HandleGesture;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.SvgCreator;
import com.cburch.draw.shapes.SvgReader;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Strings;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.GraphicsUtil;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.List;
import org.w3c.dom.Element;

public abstract class DynamicElement
extends AbstractCanvasObject {
    public static final AttributeOption LABEL_NONE = new AttributeOption("none", Strings.S.getter("circuitLabelNone"));
    public static final AttributeOption LABEL_TOP = new AttributeOption("top", Strings.S.getter("circuitLabelTop"));
    public static final AttributeOption LABEL_BOTTOM = new AttributeOption("bottom", Strings.S.getter("circuitLabelBottom"));
    public static final AttributeOption LABEL_LEFT = new AttributeOption("left", Strings.S.getter("circuitLabelLeft"));
    public static final AttributeOption LABEL_RIGHT = new AttributeOption("right", Strings.S.getter("circuitLabelRight"));
    public static final AttributeOption LABEL_CENTER = new AttributeOption("center", Strings.S.getter("circuitLabelCenter"));
    public static final Attribute<AttributeOption> ATTR_LABEL = Attributes.forOption("showlabel", Strings.S.getter("circuitShowLabelAttr"), new AttributeOption[]{LABEL_NONE, LABEL_TOP, LABEL_BOTTOM, LABEL_LEFT, LABEL_RIGHT, LABEL_CENTER});
    public static final Color COLOR = new Color(66, 244, 152);
    public static final int DEFAULT_STROKE_WIDTH = 1;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 0, 7);
    protected final Path path;
    protected Bounds bounds;
    protected int strokeWidth;
    protected AttributeOption labelLoc;
    protected Font labelFont;
    protected Color labelColor;

    public DynamicElement(Path p, Bounds b) {
        this.path = p;
        this.bounds = b;
        this.strokeWidth = 0;
        this.labelLoc = LABEL_NONE;
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelColor = Color.darkGray;
    }

    public Path getPath() {
        return this.path;
    }

    public InstanceComponent getFirstInstance() {
        return this.path.elt[0];
    }

    @Override
    public Bounds getBounds() {
        if (this.strokeWidth < 2) {
            return this.bounds;
        }
        return this.bounds.expand(this.strokeWidth / 2);
    }

    @Override
    public boolean contains(Location loc, boolean assumeFilled) {
        return this.bounds.contains(loc);
    }

    public Location getLocation() {
        return Location.create(this.bounds.getX(), this.bounds.getY(), false);
    }

    @Override
    public void translate(int dx, int dy) {
        this.bounds = this.bounds.translate(dx, dy);
    }

    @Override
    public int matchesHashCode() {
        return this.bounds.hashCode();
    }

    @Override
    public boolean matches(CanvasObject other) {
        return other instanceof DynamicElement && this.bounds.equals(((DynamicElement)other).bounds);
    }

    @Override
    public List<Handle> getHandles(HandleGesture gesture) {
        int x0 = this.bounds.getX();
        int y0 = this.bounds.getY();
        int x1 = x0 + this.bounds.getWidth();
        int y1 = y0 + this.bounds.getHeight();
        return UnmodifiableList.create(new Handle[]{new Handle(this, x0, y0), new Handle(this, x1, y0), new Handle(this, x1, y1), new Handle(this, x0, y1)});
    }

    protected Object getData(CircuitState state) {
        Object obj = state.getData(this.path.elt[0]);
        for (int i = 1; i < this.path.elt.length && obj != null; ++i) {
            if (!(obj instanceof CircuitState)) {
                throw new IllegalStateException("Expecting CircuitState for path[" + (i - 1) + "] " + String.valueOf(this.path.elt[i - 1]) + "  but got: " + String.valueOf(obj));
            }
            state = (CircuitState)obj;
            obj = state.getData(this.path.elt[i]);
        }
        return obj;
    }

    protected InstanceComponent getComponent(CircuitState state) {
        Object obj = state.getData(this.path.elt[0]);
        InstanceComponent comp = this.path.elt[0];
        for (int i = 1; i < this.path.elt.length && obj != null; ++i) {
            if (!(obj instanceof CircuitState)) {
                throw new IllegalStateException("Expecting CircuitState for path[" + (i - 1) + "] " + String.valueOf(this.path.elt[i - 1]) + "  but got: " + String.valueOf(obj));
            }
            state = (CircuitState)obj;
            comp = this.path.elt[i];
            obj = state.getData(this.path.elt[i]);
        }
        return comp;
    }

    @Override
    public String getDisplayNameAndLabel() {
        String label = this.path.leaf().getInstance().getAttributeValue(StdAttr.LABEL);
        return label != null && label.length() > 0 ? this.getDisplayName() + " \"" + label + "\"" : this.getDisplayName();
    }

    @Override
    public void paint(Graphics g, HandleGesture gesture) {
        this.paintDynamic(g, null);
    }

    public void parseSvgElement(Element elt) {
        if (elt.hasAttribute("stroke-width")) {
            this.strokeWidth = Integer.parseInt(elt.getAttribute("stroke-width").trim());
        }
        if (elt.hasAttribute("label")) {
            String loc;
            this.labelLoc = switch (loc = elt.getAttribute("label").trim().toLowerCase()) {
                case "left" -> LABEL_LEFT;
                case "right" -> LABEL_RIGHT;
                case "top" -> LABEL_TOP;
                case "bottom" -> LABEL_BOTTOM;
                case "center" -> LABEL_CENTER;
                case "none" -> LABEL_NONE;
                default -> LABEL_NONE;
            };
        }
        this.labelFont = SvgReader.getFontAttribute(elt, "", "SansSerif", 7);
        if (elt.hasAttribute("label-color")) {
            this.labelColor = SvgReader.getColor(elt.getAttribute("label-color"), null);
        }
    }

    protected Element toSvgElement(Element ret) {
        ret.setAttribute("x", "" + this.bounds.getX());
        ret.setAttribute("y", "" + this.bounds.getY());
        ret.setAttribute("width", "" + this.bounds.getWidth());
        ret.setAttribute("height", "" + this.bounds.getHeight());
        if (this.labelLoc != LABEL_NONE) {
            if (this.labelLoc == LABEL_LEFT) {
                ret.setAttribute("label", "left");
            } else if (this.labelLoc == LABEL_RIGHT) {
                ret.setAttribute("label", "right");
            } else if (this.labelLoc == LABEL_TOP) {
                ret.setAttribute("label", "top");
            } else if (this.labelLoc == LABEL_BOTTOM) {
                ret.setAttribute("label", "bottom");
            } else if (this.labelLoc == LABEL_CENTER) {
                ret.setAttribute("label", "center");
            }
        }
        if (!this.labelFont.equals(DEFAULT_LABEL_FONT)) {
            SvgCreator.setFontAttribute(ret, this.labelFont, "");
        }
        if (!SvgCreator.colorMatches(this.labelColor, Color.darkGray)) {
            ret.setAttribute("label-color", SvgCreator.getColorString(this.labelColor));
        }
        if (this.strokeWidth != 1) {
            ret.setAttribute("stroke-width", "" + this.strokeWidth);
        }
        ret.setAttribute("path", this.path.toSvgString());
        return ret;
    }

    public abstract void paintDynamic(Graphics var1, CircuitState var2);

    public void drawLabel(Graphics g) {
        if (this.labelLoc == LABEL_NONE) {
            return;
        }
        String label = this.path.leaf().getAttributeSet().getValue(StdAttr.LABEL);
        if (label == null || label.length() == 0) {
            return;
        }
        int x = this.bounds.getX();
        int y = this.bounds.getY();
        int w = this.bounds.getWidth();
        int h = this.bounds.getHeight();
        int vAlign = 0;
        int hAlign = 0;
        int pX = x + w / 2;
        int pY = y + h / 2;
        if (this.labelLoc == LABEL_TOP) {
            pY = y - 1;
            vAlign = 2;
        } else if (this.labelLoc == LABEL_BOTTOM) {
            pY = y + h + 1;
            vAlign = -1;
        } else if (this.labelLoc == LABEL_RIGHT) {
            pX = x + w + 1;
            hAlign = -1;
        } else if (this.labelLoc == LABEL_LEFT) {
            pX = x - 1;
            hAlign = 1;
        }
        g.setColor(this.labelColor);
        GraphicsUtil.drawText(g, this.labelFont, label, pX, pY, hAlign, vAlign);
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == DrawAttr.STROKE_WIDTH) {
            return (V)Integer.valueOf(this.strokeWidth);
        }
        if (attr == ATTR_LABEL) {
            return (V)this.labelLoc;
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelFont;
        }
        if (attr == StdAttr.LABEL_COLOR) {
            return (V)this.labelColor;
        }
        return null;
    }

    @Override
    public void updateValue(Attribute<?> attr, Object value) {
        if (attr == DrawAttr.STROKE_WIDTH) {
            this.strokeWidth = (Integer)value;
        } else if (attr == ATTR_LABEL) {
            this.labelLoc = (AttributeOption)value;
        } else if (attr == StdAttr.LABEL_FONT) {
            this.labelFont = (Font)value;
        } else if (attr == StdAttr.LABEL_COLOR) {
            this.labelColor = (Color)value;
        }
    }

    public static class Path {
        public final InstanceComponent[] elt;

        public Path(InstanceComponent[] elt) {
            this.elt = elt;
        }

        public boolean contains(Component c) {
            for (InstanceComponent ic : this.elt) {
                if (ic != c) continue;
                return true;
            }
            return false;
        }

        public InstanceComponent leaf() {
            return this.elt[this.elt.length - 1];
        }

        public String toString() {
            return this.toSvgString();
        }

        public String toSvgString() {
            StringBuilder s = new StringBuilder();
            for (InstanceComponent instanceComponent : this.elt) {
                Location loc = instanceComponent.getLocation();
                s.append("/").append(Path.escape(instanceComponent.getFactory().getName())).append(loc);
            }
            return s.toString();
        }

        public static Path fromSvgString(String s, Circuit circuit) throws IllegalArgumentException {
            if (!s.startsWith("/")) {
                throw new IllegalArgumentException("Bad path: " + s);
            }
            String[] parts = s.substring(1).split("(?<!\\\\)/");
            InstanceComponent[] elt = new InstanceComponent[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                InstanceComponent ic;
                String ss = parts[i];
                int p = ss.lastIndexOf("(");
                int c = ss.lastIndexOf(",");
                int e = ss.lastIndexOf(")");
                if (e != ss.length() - 1 || p <= 0 || c <= p) {
                    throw new IllegalArgumentException("Bad path element: " + ss);
                }
                int x = Integer.parseInt(ss.substring(p + 1, c).trim());
                int y = Integer.parseInt(ss.substring(c + 1, e).trim());
                Location loc = Location.create(x, y, false);
                String name = Path.unescape(ss.substring(0, p));
                Circuit circ = circuit;
                if (i > 0) {
                    circ = ((SubcircuitFactory)elt[i - 1].getFactory()).getSubcircuit();
                }
                if ((ic = Path.find(circ, loc, name)) == null) {
                    throw new IllegalArgumentException("Missing component: " + ss);
                }
                elt[i] = ic;
            }
            return new Path(elt);
        }

        private static InstanceComponent find(Circuit circuit, Location loc, String name) {
            for (Component c : circuit.getNonWires()) {
                if (!name.equals(c.getFactory().getName()) || !loc.equals(c.getLocation())) continue;
                return (InstanceComponent)c;
            }
            return null;
        }

        private static String escape(String s) {
            return s.replace("\\", "\\\\").replace("/", "\\/");
        }

        private static String unescape(String s) {
            return s.replace("\\/", "/").replace("\\\\", "\\");
        }
    }
}

