/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.data;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import java.util.ArrayList;

public abstract class AbstractAttributeSet
implements Cloneable,
AttributeSet {
    private ArrayList<AttributeListener> listeners = null;

    @Override
    public void addAttributeListener(AttributeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public boolean amIListening(AttributeListener l) {
        return this.listeners.contains(l);
    }

    @Override
    public Object clone() {
        try {
            AbstractAttributeSet ret = (AbstractAttributeSet)super.clone();
            ret.listeners = new ArrayList();
            this.copyInto(ret);
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean containsAttribute(Attribute<?> attr) {
        return this.getAttributes().contains(attr);
    }

    protected abstract void copyInto(AbstractAttributeSet var1);

    protected void fireAttributeListChanged() {
        if (this.listeners != null) {
            AttributeEvent event = new AttributeEvent(this);
            for (AttributeListener l : new ArrayList<AttributeListener>(this.listeners)) {
                l.attributeListChanged(event);
            }
        }
    }

    protected <V> void fireAttributeValueChanged(Attribute<? super V> attr, V value, V oldvalue) {
        if (this.listeners != null) {
            AttributeEvent event = new AttributeEvent(this, attr, value, oldvalue);
            ArrayList<AttributeListener> ls = new ArrayList<AttributeListener>(this.listeners);
            for (AttributeListener l : ls) {
                l.attributeValueChanged(event);
            }
        }
    }

    @Override
    public Attribute<?> getAttribute(String name) {
        for (Attribute<?> attr : this.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        return false;
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return attr.isToSave();
    }

    @Override
    public void removeAttributeListener(AttributeListener l) {
        this.listeners.remove(l);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    @Override
    public void setReadOnly(Attribute<?> attr, boolean value) {
        throw new UnsupportedOperationException();
    }
}

